import layout from './layout';
import TrLayout from './TrLayout';
import TdLayout from './TdLayout';

import {Sequence} from '../../utility';
class TableLayout extends layout{
    constructor(){
        super();
        this.type="table";
        this.text="tablelayout";
        this.cursor="default";
        this.element=[];
        this.id=Sequence.createUuid();
        this.cols=5;
        this.rows=5;
        this.trs=[];
        this.scope='tablelayout';
        this.tableClass="tablelayout";
    }
    init(){
        for(let i=0;i<this.rows;i++){
            let tr=new TrLayout();
            tr.cols=this.cols;
            tr.width=this.width;
            tr.height=this.height/this.rows;
            tr.x=this.x;
            tr.y=this.y+(this.height/this.rows)*i;
            tr.init();
            this.trs.push(tr);
            
        }
    }
    toHtml(){
        let length=this.element.length;
        let h="";
        h=`<table class='tablelayout-base' style='`+
            `left:`+
            this.left+
            `px;`+
            `top:`+
            this.top+
            `px;`+
        `'`+ 
        `>`+
        `<tbody `+
        `>`;
        
        for(let i=0;i<this.rows;i++){
            h+=`<tr>`;
            for(let j=0;j<this.cols;j++){
                h+=`<td class='tablelayout-td'>`
                let k=i*3+j;

                if(this.element[k].childrens && this.element[k].childrens.length>0){
                    let len=this.element[k].childrens.length;
                    for(let a=0;a<len;a++){
                        let scope=this.element[k].childrens[a].scope;
                        switch(scope){
                            case "input":
                                h += this.element[k].childrens[a].toHtml();
                                break;
                            default:
                                break;
                        }
                    }
                }
                h+=`</td>`
            }
            h+=`</tr>`;
            
        }
        h += `</tbody></table>`;
        return h;

    }
    parseHtml(html){
        let that=this;
        let y=that.y;
        let x= that.x;
        let root=$(html)[0];
        let j=0;
        let rowIndex=0;
        const traversalNode = (htmlNode) => {
            const {tagName}=htmlNode;
            switch(tagName){
                case 'TBODY':
                    let root2=htmlNode;
                    const traversalNode2 = (htmlNode2) => {
                        const {tagName}=htmlNode2;
                        switch(tagName){
                            case 'TR':
                                let trLayout = new TrLayout();
                                trLayout.iWhich=j;
                                trLayout.width=parseInt(htmlNode2.getAttribute("width"));

                                trLayout.height=parseInt(htmlNode2.getAttribute("height"));
                                trLayout.y=y;
                                trLayout.x=x;
                                trLayout.rowIndex=rowIndex;
                                rowIndex++;
                                y+=trLayout.height;
                                
                                trLayout.parseHtml(htmlNode2);
                                that.trs.push(trLayout);
                                
                                break;
                            default:
                                console.log("no2");
                                break;

                        }
                    }
                    if(root2.hasChildNodes()) {
                        this.rows=root2.children.length;

                        for(let i = 0;i < root2.children.length;i++) {
                            traversalNode2(root2.children[i]);
                        }
                    }
                    break;
                default:
                   // console.log("no");
                    break;

            }
        }
        if(root.hasChildNodes()) {
            let style=root.getAttribute("style");
            let obj={};
            do{
                let i=style.indexOf(":");
                let key = style.slice(0,i);
                style=style.slice(i+1);

                let j=style.indexOf(";");
                let val=style.slice(0,j);
                style=style.slice(j+1);

                obj[key]=parseFloat(val);

            }while(style.length!=0);
            this.setProps(obj);
            for(let j = 0;j < root.children.length;j++) {
                traversalNode(root.children[j]);
            }
        }
    }
    paint(){
        
        let h="";
        h=`<div class="inlineBlock" id="${this.id}" draggable="true" id="`+
        this.id+
        `"><table `+
        `width="`+
        this.width+
        `" `+
        `height="`+
        this.height+
        `"`+
        `panelx="`+
        this.x+
        `"`+
        `panely="`+
        this.y+
        `"`+
        
        `>`;
        for(let i=0;i<this.trs.length;i++){

            h+=this.trs[i].paint();
        }

        h+=`</table></div>`
        
            
        return h;
    }
    getNodeConfigInfo(){
        let node = {};
		node.text = this.text;
		node.icon = 'glyphicon glyphicon-pencil';
		node.uuid = this.id;	
        node.instance = this;
        if(this.element.length > 0) {
			node.nodes = []
			for(let i = 0, len = this.element.length;i < len;i++) {
				const data = this.element[i].getNodeConfigInfo();
				node.nodes.push(data);	
			}
		}
		return node;
    }
    addElement(elem){
        let len=this.element.length;
        for(let i=0;i<len;i++){
            if(elem.x<this.element[i].x+this.element[i].width && elem.x>this.element[i].x && elem.y<this.element[i].y+this.element[i].height && elem.y>this.element[i].y){
                elem.x=elem.x-this.element[i].x;
                elem.y=elem.y-this.element[i].y;
                elem.belongId=this.element[i].id;
                this.element[i].childrens.push(elem);
                return true;
            }
            
        }
        return false;
    }
    resetElementToChunk(elem){
        let len=this.element.length;
        for(let k=0;k<len;k++){
            if(this.element[k].id==elem.belongId){
                let ind;
                for(let j=0;j<this.element[k].childrens.length;j++){
                    if(elem.id==this.element[k].childrens[j].id){
                        ind=j;
                    }
                }
                this.element[k].childrens.splice(ind,1);
            }
        }
        for(let i=0;i<len;i++){
            //由于布局下的元素存的位置是相对于布局的左上角的坐标，所以计算的时候应该是元素的坐标值加上布局左上角的坐标值小于所在区域的相对于panel的位置，注意加上dewidth和height的乘数
            if(elem.x+this.x<this.x+this.element[i].width*(i%this.cols+1) && elem.x+this.x>this.x && elem.y+this.y<this.y+this.element[i].height*(Math.ceil((i+1)/this.rows)) && elem.y+this.y>this.y){
                // elem.x=elem.x-this.element[i].x;
                // elem.y=elem.y-this.element[i].y;
                elem.belongId=this.element[i].id;
                this.element[i].childrens.push(elem);
                return true;
            }
            
        }
        return false;
    }
    resetTrLayout(moveY){
        this.trs.forEach((elm)=>{
            elm.y +=moveY;
            // elm.height +=moveY;
            elm.resetTdLayout(moveY);
        })
    }
    getRealRowCol(row,col){
        for(let i=0;i<this.trs.length;i++){
            for(let j=0;j<this.trs[i].tds.length;j++){
                if(this.trs[i].tds[j].rowIndex==row &&this.trs[i].tds[j].colIndex==col){
                    return {"realrow":i,"realcol":j}
                }
            }
        }
    }
    //get合并单元格用的
    resetCellSpan(row,col){
        this.trs.forEach(elm=>{
            if(elm.haveCellSpan.length>0){
                elm.haveCellSpan.forEach(el=>{
                    if(el.rowIndex==row && el.colIndex == col){
                        el.rowspan+=1;
                    }
                })
            }
        })
    }
    //重置所有的havecellspan
    /**
     * 遍历所有tr，找到主动受改变的单元格，找到一个遍历一次table的所有单元格，
     * 用这个主动地行列号去寻找被动受影响的行列号，
     * 然后改变被动受影响的行列号，来确定最后rowspan数字，所以这里要确定每次删除或者增加行之后，
     * 主动收到影响的单元格的内容一定要正确，不然这个重置会出错
     * 
     * 遍历所有的td，如果有合并单元格的，找到行号和列号然后记录下来，之后再给被动受影响的行加上被动记录，
     */
    resetAllCellSpan(){
        let that=this;
        for(let i=0;i<this.trs.length;i++){
            this.trs[i].haveCellSpan=[]
        };
        for(let j=0;j<this.trs.length;j++){
            for(let k=0;k<this.trs[j].tds.length;k++){
                if(this.trs[j].tds[k].rowspan!=1){
                    let rowspan=this.trs[j].tds[k].rowspan;
                    let colIndex=this.trs[j].tds[k].colIndex;
                    this.trs[j].haveCellSpan.push({"rowIndex":j,"colIndex":k,"rowspan":this.trs[j].tds[k].rowspan,"isActive":true});
                    for(let a=j+1;a<rowspan+j;a++){
                        this.trs[a].haveCellSpan.push({"rowIndex":j,"colIndex":k,"rowspan":this.trs[j].tds[k].rowspan,"isActive":false})
                    }
                }
            }
        }
    }
    //重置所有向右的havecellRightspan
    /**
     *  循环tr里面的td，找到有向右合并的单元格，然后对改行进行改动，并且修改用来记录的信息
     * 
     *   */
    resetAllCellRightSpan(){
        let that=this;
        for(let i=0;i<this.trs.length;i++){
            this.trs[i].haveCellRightSpan=[]
        };
        for(let j=0;j<this.trs.length;j++){
            for(let k=0;k<this.trs[j].tds.length;k++){
                if(this.trs[j].tds[k].colspan!=1){
                    let colspan=this.trs[j].tds[k].colspan;
                    this.trs[j].haveCellRightSpan.push({"rowIndex":j,"colIndex":k,"colspan":colspan,"isActive":true});
                }
            }
        }
    }
    //重置所有trtd的坐标和记录下角标的值
    /**
     * 注：这个方法执行无错的前提是td的rowspan和colspan，height和width保存的是正确的
     * 拿到初始的x，y给第一个单元格，然后判断该单元格是否有向右和向下的合并单元格，
     * 有向右的单元格，记录向右多少个然后重置改行下一个td的colindex，
     * 有向下的单元格，记录向下多少个，然后以后遍历下一行的时候要对该单元格下面的单元格所在行的colindex的初始值+1
     *  还没有想好怎么写2019.12.26
     *  */
    // resetPositionAndIndex(){
    //     let x=this.x,
    //         y=this.y,
    //         that=this,
    //         // rowLen=0,
    //         rowLen=null,
    //         haveRowspan=false;

    //     for(let i=0;i<this.trs.length;i++){
    //         let colLen=0,
    //         rowNum=0,
    //         colStart=0;
    //         this.trs[i].rowIndex=i;
    //         for(let j=0;j<this.trs[i].tds.length;j++){
    //             // if(haveRowSpan && rowLen!=0){
    //             //     rowLen--;
    //             //     colStart=j+rowNum;
    //             // }else{
    //                 colStart=j;
    //             // }
                
    //             if(j==0 && i==0){
    //                 this.trs[i].tds[j].colIndex=0;
    //                 this.trs[i].tds[j].rowIndex=0;

    //             }
    //             if(this.trs[i].tds[j].colspan!=1 ){
    //                 //当前单元格有向右的合并，没有向下的
    //                 colLen=colStart+this.trs[i].tds[j].colspan-1;
    //                 // colLen++;
    //                 this.trs[i].tds[j].colIndex=colLen;
    //                 this.trs[i].tds[j].rowIndex=rowLen;

    //                 this.trs[i].tds[j].rowIndex=i;
    //             }else if(this.trs[i].tds[j].rowspan!=1){
    //                 //当前单元格有向下的合并，没有向右的
    //                 // rowNum++;//用来记录当前行有多少个单元格有向下合并单元格
    //                 // rowLen=this.trs[i].tds[j].rowspan-1;
    //                 // haveRowspan=true;
    //                 this.trs[i].tds[j].rowIndex=rowLen;
    //                 this.trs[i].tds[j].colIndex=j;

    //             }
    //         }
    //     }

    // }


    copyFn(obj) {
        if (obj == null) {
             return null
         }
         var result = Array.isArray(obj) ? [] : {};
         for (let key in obj) {
             if (obj.hasOwnProperty(key)) {
                 if (typeof obj[key] === 'object') {
                     result[key] = this.copyFn(obj[key]);  // 如果是对象，再次调用该方法自身
                 }else if (typeof obj[key] === 'function') {
                    result[key] = this.copyFn(obj[key]);  // 如果是对象，再次调用该方法自身
                } else {
                     result[key] = obj[key];
                 }
             }
         }
         return result;
    }
    
    /**
     *复制一个tr  
     *  暂时没有找到如何深拷贝一个实例化的对象而不影响实例化对象的原型方法
     *  */
    copyTr(cloneRow,preRow){
        cloneRow.cols=preRow.cols;
        cloneRow.x=preRow.x;
        cloneRow.y=preRow.y;
        cloneRow.width=preRow.width;
        cloneRow.height=preRow.height;
        cloneRow.rowIndex =preRow.rowIndex;
        cloneRow.init();
        if(cloneRow.tds.length!=preRow.tds.length){
            cloneRow.tds.splice(preRow.tds.length,cloneRow.tds.length-preRow.tds.length)
        }
        preRow.tds.forEach((elm,index)=>{
            cloneRow.tds[index].x=elm.x;
            cloneRow.tds[index].y=elm.y;
            cloneRow.tds[index].width=elm.width;
            cloneRow.tds[index].height=elm.height;
            cloneRow.tds[index].colspan=elm.colspan;

        })

    }
    /**
     *复制一个td  
     *  暂时没有找到如何深拷贝一个实例化的对象而不影响实例化对象的原型方法
     *  */
    copyTd(cloneCol,preCol){
        cloneCol.x=preCol.x;
        cloneCol.y=preCol.y;
        cloneCol.width=preCol.width;
        cloneCol.height=preCol.height;
        cloneCol.rowIndex=preCol.rowIndex;
        cloneCol.colIndex=preCol.colIndex;
    }

     /**
     *重置所有td的y轴坐标
     *  */
    resetAllTdY(){
        for(let j=0;j<this.trs.length;j++){
            for(let k=0;k<this.trs[j].tds.length;k++){
                this.trs[j].tds[k].y=this.trs[j].y
            }
        }
    }


    /**
     * ps 以下行列单元格均是拿tr的rowindex，和td的colindex，td的rowindex不方便修改。
     */ 
    /** 
     * 插入一行
     * 
     * 1.获得当前要clone的行，复制当前行，注意深拷贝问题(未完全解决)
     * 2.用splice来插入指定的行，
     * 3.reset坐标，如果当前插入的地方是首位，那后面所有都要变化，如果不是，那就之后的变化就可以
     * 4.repaint
     * 1.现在改用参数代替下标，就不能直接操作数组，先遍历tr，拿到对应参数的tr的i值然后进行操作，无论删除还是增加都得对之后的参数进行从新赋值
     * 现在简易版的是直接在下方插入，，所以只需要改变之后的参数，之后如果增加方法之后要判断或者直接对全部进行重新赋值（ps，性能消耗大）；
     * 
     * ps 2019.12.2 加上如果该行有合并单元格的情况，新增一行的时候要注意处理合并的单元格,现在考虑的都是两个单元格合并的，多个的还没有考虑
     * 接收到一个参数，是当前鼠标在的行数，判断当前的行的tds的length是否等于当前table的cols，然后
     * 
     * 2019.12.16
     * 现在考虑的情况还没有考虑到向下和向右一起来的情况。
        1）如果当前鼠标所在单元格存在合并单元格，
        如果存在向右合并的单元格直接复制信息。
        存在的话：判断鼠标所在单元格的行的向下合并单元格管辖范围内的最后一行是否有超出范围的向下合并单元格，
                    有的话新增的行要继承（这个词待斟酌）超出范围的合并单元格，
                    没有的话就可以直接新增，不需要继承合并单元格。直接新增的行是一个带有当前行的高度的原始行。
        不存在的话：判断改行是否有存在被动或者主动受影响的单元格，有的话要处理一下，没有的话，说明该行是一个原始表格行
        所有的情况结束之后都要处理坐标高度等信息。
    */
    insertRow(RowIndex,realRowIndex,ColIndex,cellHaveRowspan){
        console.log("insertRow",RowIndex)
        let that=this;
        let insertRowIndex = null,haveRowSpan=null,mouseColIndex=null,range=null,insertRow=new TrLayout(),deleteColIndex=null;
        insertRow.cols=this.cols;
        
        if(RowIndex==realRowIndex && !cellHaveRowspan){
            insertRowIndex=realRowIndex;
            insertRow.width=this.trs[realRowIndex].width;
            insertRow.height=this.trs[realRowIndex].height;
            insertRow.init();//高度继承了当前鼠标所在行，单元格是初始的
            //当前单元格不是合并单元格，新增的行加在该合并单元格之后
            //当前的rowindex+1就是要添加的行的位置
            //判断当前的行是否存在主动被动的单元格，
            //主动受影响的单元格，下面新增的一行要去掉当前列的单元格，被动受影响的，还是要处理的 2019.12.25
            //被动受影响的，如果当前行是最后一个被动受影响的，就直接插入一个原始行，不做处理，如果不是最后一个被动受影响的，那还是要处理
            if(this.trs[RowIndex].haveCellSpan.length>0){
                this.trs[RowIndex].haveCellSpan.forEach(elm=>{
                    if(elm.isActive){
                        //主动受影响的
                        // insertRow.tds.splice(elm.colIndex,1);
                        insertRow.tds.forEach((el,index)=>{
                            if(el.colIndex==that.trs[elm.rowIndex].tds[elm.colIndex].colIndex){
                                deleteColIndex=index;
                            }
                        })
                        insertRow.tds.splice(deleteColIndex,1);
                        insertRow.cols-=1;
                        that.trs[RowIndex].tds[elm.colIndex].rowspan+=1;
                        that.trs[RowIndex].tds[elm.colIndex].height+=insertRow.height;

                    }else{
                        if(realRowIndex!==elm.rowIndex+elm.rowspan-1){
                            //不在最后一行受影响的
                            insertRow.tds.forEach((el,index)=>{
                                if(el.colIndex==that.trs[elm.rowIndex].tds[elm.colIndex].colIndex){
                                    deleteColIndex=index;
                                }
                            })
                            insertRow.tds.splice(deleteColIndex,1);
                            insertRow.cols-=1;
                            that.trs[elm.rowIndex].tds[elm.colIndex].rowspan+=1;
                            that.trs[elm.rowIndex].tds[elm.colIndex].height+=insertRow.height;

                        }
                    }
                })
                
            }
            that.trs.splice(realRowIndex+1,0,insertRow)

        }else{
            //当前单元格是合并单元格 ，判断当前合并单元格的最后一行是否有超出范围的合并单元格，有的话要继承
            insertRow.width=this.trs[realRowIndex].width;
            insertRow.height=this.trs[realRowIndex].height;
            insertRow.init();//高度继承了当前鼠标所在行，单元格是初始的
            let lastTrIndex=null;
            lastTrIndex=RowIndex+this.trs[RowIndex].tds[ColIndex].rowspan-1;
            insertRowIndex=lastTrIndex;
            if(this.trs[lastTrIndex].haveCellSpan.length>0){
                this.trs[lastTrIndex].haveCellSpan.forEach(elm=>{
                    if(elm.rowIndex+elm.rowspan-1>lastTrIndex){
                        //有超出范围的合并单元格，要继承
                        insertRow.tds.forEach((el,index)=>{
                            if(el.colIndex==that.trs[elm.rowIndex].tds[elm.colIndex].colIndex){
                                deleteColIndex=index;
                            }
                        })
                        insertRow.tds.splice(deleteColIndex,1);
                        insertRow.cols-=1;
                        that.trs[elm.rowIndex].tds[elm.colIndex].rowspan+=1;
                        that.trs[elm.rowIndex].tds[elm.colIndex].height+=insertRow.height;

                    }
                })
            }
            that.trs.splice(insertRowIndex+1,0,insertRow)
        }
        this.height += insertRow.height;
        let x=0,y=0;
        if(insertRowIndex!=0){
            x=this.trs[insertRowIndex-1].x;
            y=this.trs[insertRowIndex-1].y;
        }
        for(let j = insertRowIndex;j<this.trs.length;j++){
            this.trs[j].x = x;
            if(j==0){
                this.trs[j].rowIndex=j;
                this.trs[j].y = y;
                y+=0
            }else{
                this.trs[j].rowIndex=this.trs[j-1].rowIndex+1;
                this.trs[j].y = y+this.trs[j-1].height;
                y+=this.trs[j-1].height;
            }
            for(let k=0;k<this.trs[j].tds.length;k++){
                this.trs[j].tds[k].rowIndex = this.trs[j].rowIndex
            }
        }
        this.resetAllTdY();
        this.rows +=1;
        that.resetAllCellSpan()
    }
    /** 
     * 删除一行
     * 如果该行有和下一行合并单元格的情况，要处理
     * 拿到当前鼠标所在的行数
     * 然后删除该行
     * ，记得要对单元格的合并属性调整
     *  
     * 2019.12.14
     * 如果当前鼠标在的cell是没有合并单元格的，直接删除该行，且判断在这行中是否有合并单元格的存在（）,然后要改变这行的合并单元格的属性
     * 如果当前鼠标在的cell有合并单元格的存在，则直接删除合并单元格的行，
     * 
    */
    deleteRow(RowIndex,realRowIndex,ColIndex,cellHaveRowspan){
        let that=this;
        console.log("deleteRow",realRowIndex)
        // let cellHave=null;//用来判别是否有合并单元格
        // let cellspans=[]; //用来记录当前单元格所在行，那些单元格有合并单元格，这个是指向下的，
        //判断当前单元格拿到的行数是否一致，一致则表明当前单元格没有合并单元格
        let x=0,y=0;
        let deleteRowIndex = null;
        //这个判断不够严谨，还要判断当前鼠标所在单元格是否有向下合并单元格   已修改
        if(RowIndex==realRowIndex && !cellHaveRowspan){
            //没有
            // cellHave=false;
            let activeRowSpan=[] ,unActiveRowSpan=[],  addRow=null;
            //拿到要删除的行数和有单元格合并的那行的列数
            //拿到当前单元格所在行所有主动被动受影响的合并单元格

            deleteRowIndex=realRowIndex;
            this.trs[realRowIndex].haveCellSpan.forEach(elm=>{
                if(elm.isActive){
                    activeRowSpan.push(elm)
                }else{
                    unActiveRowSpan.push(elm)
                }
            })
            //删除之后进行的更新其他问题 1.先处理因为该行删除收到影响的单元格，然后再删除，再然后处理具体坐标问题
            let deleteRow=new TrLayout();
            this.copyTr(deleteRow,this.trs[deleteRowIndex])
            if(activeRowSpan.length>0){
                activeRowSpan.forEach(elm=>{
                    //主动受影响的，将合并单元格的下一行新增一个单元格，并且继承这一单元格的合并单元格数减一,还要改变高度,并且还要改变记录
                    let addCol = new TdLayout();
                    that.copyTd(addCol,that.trs[elm.rowIndex].tds[elm.colIndex])
                    addCol.height=that.trs[elm.rowIndex].height;
                    that.trs[elm.rowIndex+1].tds.splice(elm.colIndex,0,addCol);
                    that.trs[elm.rowIndex+1].cols+=1;
                    that.trs[elm.rowIndex+1].haveCellSpan.forEach(el=>{
                        if(el.rowIndex==elm.rowIndex && el.colIndex==elm.colIndex){
                            el.isActive=true;
                        }
                    })
                    that.trs[elm.rowIndex+1].tds[elm.colIndex].rowspan=that.trs[elm.rowIndex].tds[elm.colIndex].rowspan-1;
                    // this.trs[elm.rowIndex+1].tds[elm.colIndex].hide=false;
                    if(that.trs[elm.rowIndex].tds[elm.colIndex].rowspan!=2){
                        let addHeight=0;
                        that.trs[elm.rowIndex+1].tds[elm.colIndex].rowspan=that.trs[elm.rowIndex].tds[elm.colIndex].rowspan-1;
                        let len=that.trs[elm.rowIndex+1].tds[elm.colIndex].rowspan;
                        for(let m=elm.rowIndex+2;m<elm.rowIndex+1+len;m++){
                            // that.trs[m].tds[elm.colIndex].hide=true;
                            addHeight+=that.trs[m].tds[elm.colIndex].height;
                            // that.trs[m].tds.splice(elm.colIndex,1)
                            
                        }
                        that.trs[elm.rowIndex+1].tds[elm.colIndex].height+=addHeight;
    
                    }
                })
            }
            if(unActiveRowSpan.length>0){
                unActiveRowSpan.forEach(elm=>{
                    //被动受影响的，将受影响的单元格的rowspan减一，并且高度变化
                    that.trs[elm.rowIndex].tds[elm.colIndex].rowspan-=1;
                    that.trs[elm.rowIndex].tds[elm.colIndex].height-=deleteRow.height;
                })
            }
            
            this.trs.splice(deleteRowIndex,1);
            this.height-=deleteRow.height;
            if(deleteRowIndex!=0){
                x=this.trs[deleteRowIndex-1].x;
                y=this.trs[deleteRowIndex-1].y;
    
            }
            for(let i = deleteRowIndex;i<this.trs.length;i++){
                this.trs[i].x = x;
                if(i==0){
                    this.trs[i].rowIndex=i;
                    this.trs[i].y=y;
                    y+=0
                }else{
                    this.trs[i].rowIndex=this.trs[i-1].rowIndex+1;
                    this.trs[i].y = y+this.trs[i-1].height;
                    y+=this.trs[i-1].height;
                }
                for(let k=0;k<this.trs[i].tds.length;k++){
                    this.trs[i].tds[k].rowIndex = this.trs[i].rowIndex;
                    this.trs[i].tds[k].y=this.trs[i].y;
                }
            }
            this.rows -=1;
            
        }else{
            //有
            let haveRowSpan=null,addRow=null;
            // 当前鼠标在的单元格有合并单元格，直接删除该合并单元格跨的多行，要检查最后一行或者第一行是否存在主动或被动的合并单元格，如果有的话要处理一下
            //拿到删除的行的正确行号和单元格合并的正确列号
            for(let j=0;j<this.trs.length;j++){
                if(this.trs[j].rowIndex == RowIndex){
                    // deleteRowIndex=j;
                    if(RowIndex==realRowIndex){
                        deleteRowIndex=j;
                    }
                    for(let m=0;m<this.trs[j].tds.length;m++){
                        if(this.trs[j].tds[m].colIndex==ColIndex){
                            haveRowSpan=m;
                            break;
                        }
                    }
                }
                else if(this.trs[j].rowIndex == realRowIndex){
                    deleteRowIndex=j;
                }
            }
            //看看删除的最后一行是否有合并单元格
            if(this.trs[RowIndex+this.trs[RowIndex].tds[haveRowSpan].rowspan-1].haveCellSpan.length>0){
                let lastTr=this.trs[RowIndex+this.trs[RowIndex].tds[haveRowSpan].rowspan-1];
                lastTr.haveCellSpan.forEach(elm=>{
                    let elmRowIndex=elm.rowIndex,elmColIndex=elm.colIndex;
                    let delRow=RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan;
                    // && (elm.rowIndex!==RowIndex &&elm.colIndex !==ColIndex)
                    if((elm.rowIndex+elm.rowspan)>delRow ){
                        //有合并单元格，并且超出了删除的范围,给删除的最后一行的下一行加上新的单元格，并且继承rowspan
                        if(elm.rowIndex>=RowIndex){
                            //最后一行有在删除行合并单元格起始行之后的行，（有点绕）
                            let addTd = new TdLayout();
                            that.copyTd(addTd,that.trs[elm.rowIndex].tds[elm.colIndex]);

                            addTd.rowspan= RowIndex!==elm.rowIndex?elm.rowspan-(RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan-1):elm.rowspan-that.trs[RowIndex].tds[haveRowSpan].rowspan;
                            let h=addTd.rowspan*(that.trs[elm.rowIndex].tds[elm.colIndex].height/that.trs[elm.rowIndex].tds[elm.colIndex].rowspan);
                            
                            addTd.height=h;
                            let insertPosition=null;
                            if(RowIndex==elm.rowIndex){
                                insertPosition=elm.colIndex;
                                that.trs[RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan].tds.splice(insertPosition,0,addTd);
                                that.trs[RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan].cols+=1;
                                
                            }else{
                                for(let c=0;c<that.trs[RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan].tds.length;c++){
                                    console.log(that.trs[RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan].tds[c].colIndex)
                                    if(that.trs[RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan].tds[c].colIndex==elm.colIndex){
                                        insertPosition = c;
                                        break;
                                    }
                                }
                                if(insertPosition == null){
                                    insertPosition=0;
                                }
                                that.trs[RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan].tds.splice(insertPosition+1,0,addTd);
                                that.trs[RowIndex+that.trs[RowIndex].tds[haveRowSpan].rowspan].cols+=1;
                            }
                        }else{
                            //补充当第一列中间两行有合并，第三列有四行合并，然后再第一列删除中间两行的情况，此时只需要改变当前elm的高度和rowspan,还要改变因为这个影响的其他haveCellSpan的值
                            let delH=null;
                            for(let n=RowIndex;n<that.trs[RowIndex].tds[haveRowSpan].rowspan+1;n++){
                                delH+=that.trs[n].height;
                            }
                            that.trs[elm.rowIndex].tds[elm.colIndex].height-=delH;
                            that.trs[elm.rowIndex].tds[elm.colIndex].rowspan-=that.trs[RowIndex].tds[haveRowSpan].rowspan;
                            for(let a=0;a<this.trs.length;a++){
                                that.trs[a].haveCellSpan.forEach(el=>{
                                    if(el.rowIndex==elm.rowIndex && el.colIndex == elm.colIndex){
                                        el.rowspan-=that.trs[RowIndex].tds[haveRowSpan].rowspan;
                                    }
                                })
                            }
                            
                        }
                        

                    }
                })
            }
            //看看第一行是否有受影响的
            //还没写
            // for(let a=0;a<this.trs[RowIndex+this.trs[RowIndex].tds[haveRowSpan].rowspan-1].length;a++){

            // }
            //删除之后要更新后面的坐标和相关的高度之类的
            let delH=null;
            for(let n=RowIndex;n<this.trs[RowIndex].tds[haveRowSpan].rowspan+1;n++){
                delH+=this.trs[n].height;
            }
            this.trs.splice(RowIndex,this.trs[RowIndex].tds[haveRowSpan].rowspan);
            this.height -= delH;
            if(RowIndex!=0){
                x=this.trs[RowIndex-1].x;
                y=this.trs[RowIndex-1].y;
    
            }
            for(let i = RowIndex;i<this.trs.length;i++){
                this.trs[i].x = x;
                if(i==0){
                    this.trs[i].rowIndex=i;
                    this.trs[i].y=y;
                    y+=0
                }else{
                    this.trs[i].rowIndex=this.trs[i-1].rowIndex+1;
                    this.trs[i].y = y+this.trs[i-1].height;
                    y+=this.trs[i-1].height;
                }
                for(let k=0;k<this.trs[i].tds.length;k++){
                    this.trs[i].tds[k].rowIndex = this.trs[i].rowIndex;
                    this.trs[i].tds[k].y=this.trs[i].y;
                }
            }
            this.rows -=1;
        }
        that.resetAllCellSpan()
        
    }
    /** 
     * 新增一列
     * 1.拿到鼠标所在这一列的所有列
     * 2.将这些列按次序插入到每一个tr中，记得添加之后要更新之后的td的坐标
     * 3.然后table的col加一个，tr的col加一个
     * 
     *  1）如果当前单元格有向右合并单元格，（不管所在列是否有向下的合并）那就直接复制当前向右合并单元格范围内的最后一列，然后增加，不继承向右的合并，但会继承向下的合并
        2）如果当前单元格有向下合并单元格，且当前单元格所在列有向右合并单元格，若当前列不是范围内最后一列，则新增的列要继承向右和向下
                                                                若当前列是范围内最后一列，则新建的列不继承向右，只继承向下
        3）如果当前单元格没有向右合并单元格，但是当前单元格所在列有向右合并单元格，且当前单元格所在列不是向右合并单元格的最后一列，那要继承当前列，且继承向右和向下的合并

    */
    insertCol(RowIndex,ColIndex){
        let that=this,insertColIndex=null,addWidth=null,haveBottomRowspan=false,bottomRowspan=0;
        console.log("insertCol",ColIndex)
        
        if(this.trs[RowIndex].tds[ColIndex].colspan!=1 ){
            //当前单元格是向右合并的单元格，直接复制最后一列的，增加到后面
            
            for(let i=0;i<this.trs.length;i++){
                let insertIndex=null;
                let have=false;
                let addCell=new TdLayout();
                if(i==RowIndex){
                    addCell.width=this.trs[RowIndex].tds[ColIndex].width/this.trs[RowIndex].tds[ColIndex].colspan;
                    addCell.height=this.trs[RowIndex].tds[ColIndex].width/this.trs[RowIndex].tds[ColIndex].height;

                    addWidth=addCell.width;
                    addCell.colIndex=this.trs[RowIndex].tds[ColIndex].colIndex+this.trs[RowIndex].tds[ColIndex].colspan;
                    insertIndex=ColIndex;
                    insertColIndex=ColIndex;

                    that.trs[i].tds.splice(insertIndex+1,0,addCell)
                    this.trs[i].cols+=1;
                }else{
                    //复制最后一列的，但是要判断最后一列的单元格是否有超出范围的合并单元格的，有的话要继承。
                    let colIndex=this.trs[RowIndex].tds[ColIndex].colIndex+this.trs[RowIndex].tds[ColIndex].colspan-1;
                    
                    if(that.trs[i].haveCellRightSpan.length>0){
                        that.trs[i].haveCellRightSpan.forEach(elm=>{
                            if(elm.colIndex+elm.colspan>that.trs[RowIndex].tds[ColIndex].colspan+ColIndex && elm.colIndex<=colIndex){
                                //如果当前行在当前单元格的情况下有超出范围的向右单元格，那要继承向右的单元格，所以不需要addCell
                                addCell=null;
                                that.trs[i].tds[elm.colIndex].colspan+=1;
                                that.trs[i].tds[elm.colIndex].width+=that.trs[i].tds[elm.colIndex].width/that.trs[i].tds[elm.colIndex].colspan;
                                have=true;
                            }
                        })
                    }
                    if(!have){
                        //当前行的指定单元格，没有超出范围的向右合并单元格
                        for(let j=0;j<that.trs[i].tds.length;j++){
                            if(that.trs[i].tds[j].colIndex==colIndex){
                                insertIndex=j;//拿到最后一列的下标
                            }
                        }
                        if(insertIndex){
                            addCell.width=that.trs[i].tds[insertIndex].width;
                            addCell.height=that.trs[i].tds[insertIndex].height;
                            addWidth=addCell.width;
                            addCell.rowspan=that.trs[i].tds[insertIndex].rowspan;
                            //因为在下面统一对colindex进行不是很方便，因为要记录行号和列号，
                            if(that.trs[i].tds[insertIndex].rowspan!=1){
                                that.trs[i].haveCellSpan.push({"rowIndex":i,"colIndex":insertIndex+1,"rowspan":that.trs[i].tds[insertIndex].rowspan,"isActive":true})
                                for(let b=0;b<that.trs[i].tds[insertIndex].rowspan-1;b++){
                                    that.trs[i].haveCellSpan.push({"rowIndex":i,"colIndex":insertIndex+1,"rowspan":that.trs[i].tds[insertIndex].rowspan,"isActive":false})

                                }
                            }
                            that.trs[i].tds.splice(insertIndex,0,addCell)
                            this.trs[i].cols+=1;
                        }
                        
                    }
                    
                    
                    // addCell.width=this.trs[i].tds[insertIndex].width;
                }
                if(have){
                    break;
                }
            }
        }else if(this.trs[RowIndex].tds[ColIndex].rowspan!=1 ){
            let colIndex=this.trs[RowIndex].tds[ColIndex].colIndex;
            //当前单元格不是向右合并的单元格，是向下合并的单元格,
            //判断当前单元格所在列是否有合并单元格的存在
            let have=false,row=[];
            for(let s=0;s<this.trs.length;s++){
                // for(let t=0;t<this.trs[s].tds.length;t++){
                //     if(this.trs[s].tds[t].colIndex==colIndex && )
                // }
                if(this.trs[s].tds[ColIndex].colIndex!==colIndex){
                    have=true;
                    row.push(s);
                    
                }
            }
            if(have){
                //当前向下合并的单元格所在列有向右合并单元格
                
            }

        }
        // let addWidth=0;
        // let insertColIndex = null;
        // for(let m=0;m<this.trs.length;m++){
        //     for(let n=0;n<this.trs[m].tds.length;n++){
        //         if(this.trs[m].tds[n].colIndex == ColIndex){
        //             insertColIndex=n;
        //             break;
        //         }
        //     }
        // }

        // for(let k=0;k<this.trs.length;k++){
        //     let cloneCol = new TdLayout();
        //     this.copyTd(cloneCol,this.trs[k].tds[insertColIndex])
        //     if(this.trs[k].tds[insertColIndex].colspan!=1){
        //         cloneCol.width=this.trs[k].tds[insertColIndex].width/this.trs[k].tds[insertColIndex].colspan
        //     }
        //     addWidth=cloneCol.width;
        //     this.trs[k].width += cloneCol.width
        //     this.trs[k].tds.splice(insertColIndex,0,cloneCol)
        //     this.trs[k].cols+=1;
        // }
        this.width += addWidth;
        for(let i=0;i<this.trs.length;i++){
            let x=0,y=0;
            for(let j = insertColIndex;j<this.trs[i].tds.length;j++){
                this.trs[i].tds[j].rowIndex=this.trs[i].rowIndex;
                if(j!=0){
                    x=this.trs[i].tds[j-1].x;
                    y=this.trs[i].tds[j-1].y;
                }
                this.trs[i].tds[j].y =y;
                if(j==0){
                    // this.trs[i].tds[j].colIndex = j;
                    this.trs[i].tds[j].x=x;
                }else{
                    //这里重置colindex要考虑上一行有向下合并单元格的情况,最好写一个重置xy坐标和rowindex和colindex的方法
                    
                    // this.trs[i].tds[j].colIndex = this.trs[i].tds[j-1].colIndex+1;
                    this.trs[i].tds[j].x =x+this.trs[i].tds[j-1].width;
                }
            }
        }
        //单独对colindex进行处理,这个就得保证每行存储的havecellspan时正确的
        //正常情况下，colindex的值应该是数组下标值，但是如果改行有被动受影响的单元格时，当下标等于该被动受影响的单元格的下表，应该进行跳跃
        for(let k=0;k<this.trs.length;k++){
            let num=0;
            for(let t=0;t<this.trs[k];t++){
                if(this.trs[k].haveCellSpan.length>0){
                    let have=false;
                    this.trs[k].haveCellSpan.forEach(elm=>{
                        if(j==elm.colIndex && !elm.isActive){
                            num+=1;
                            have=true;
                        }
                    })
                    if(!have){
                        num+=1;
                    }
                }else{
                    num++;
                }
                
            }
        }
        this.cols +=1;
        
    }
    /** 
     * 删除一列
     * 1.删除所有行的指定列
     * 2.删除之后对table的width和tr的width要改动，还要改动之后的td的x值
     * ps 2019.12.2,删除的时候如果有合并单元格，应该先做拆分再删除这样更合适
    */
    deleteCol(ColIndex){
        console.log("deleteCol",ColIndex)

        let deleteColIndex = null;
        for(let m=0;m<this.trs.length;m++){
            for(let n=0;n<this.trs[m].tds.length;n++){
                if(this.trs[m].tds[n].colIndex == ColIndex){
                    deleteColIndex=n;
                    break;
                }
            }
        }
        let delWidth = 0;
        let that=this;
        this.trs.forEach(elm=>{
            let arr=elm.tds.map(o => ({...o}))
            for(let r=0;r<arr.length;r++){
                if(arr[r].colspan!=1){
                    let addTd=new TdLayout();
                    arr[r].width=arr[r].width/arr[r].colspan;
                    arr[r].colspan=1;
                    elm.tds[r].width=elm.tds[r].width/elm.tds[r].colspan;
                    elm.tds[r].colspan=1;
                    that.copyTd(addTd,arr[r]);
                    elm.tds.splice(r,0,addTd)
                }
            }
            delWidth=elm.tds[deleteColIndex].width;
            elm.width -=elm.tds[deleteColIndex].width;
            elm.tds.splice(deleteColIndex,1);
            elm.cols-=1;
        })
        this.width -=delWidth;
        for(let i=0;i<this.trs.length;i++){
            let x=0,y=0;
            for(let j=deleteColIndex;j<this.trs[i].tds.length;j++){
                this.trs[i].tds[j].rowIndex=this.trs[i].rowIndex;
                if(j!=0){
                    x=this.trs[j-1].x;
                    y=this.trs[j-1].y;
                }
                this.trs[i].tds[j].y=y;
                if(j==0){
                    this.trs[i].tds[j].colIndex=j;
                    this.trs[i].tds[j].x=x;
                }else{
                    this.trs[i].tds[j].colIndex = this.trs[i].tds[j-1].colIndex + 1;
                    this.trs[i].tds[j].x=x+this.trs[i].tds[j-1].width;
                }
            }
        }
        this.cols -=1;
    }
    /** 
     * ps 不能用下标来操作数组，用数组内的属性来操作
     * 记得对数组内的属性进行修改
     * 
     * 向右合并单元格
     * 1.拿到当前的单元格，和右边的第一个单元格（如果有的话）
     * 2.给当前的单元格设置colspan
     * 3.之后的cols应该也要更改
     * 4.然后删除右边的单元格
     * 向下合并单元格
     * 1.拿到当前的单元格，判断当前点下的单元格下面是否还有单元格，有的话拿到下一个单元格进行合并操作，
     * 没有的话继续往下一行找，直到找到为止 ，找到最后一行都没有的话，记得弹窗提示
     * 
     * 
     * 2.给当前的单元格设置rowspan
     * 3.然后下一行的cols-1
     * 4.删除下一行的单元格
    */
    mergeCells(direction,RowIndex,ColIndex){
        console.log("cells",RowIndex,ColIndex)
        let row=null,col=null,nextRow=null,nextCol=null;
        //拿到鼠标所在单元格的td的行号和列号
        for(let m=0;m<this.trs.length;m++){
            if(this.trs[m].rowIndex == RowIndex){
                row=m;
                for(let n=0;n<this.trs[m].tds.length;n++){
                    if(this.trs[m].tds[n].colIndex == ColIndex){
                        col=n;
                        break;
                    }
                }
            }
            
        }
        // 向下合并单元格，//(后面的没做)先判断下面这个单元格是否已经合并，如果已经合并就往下再走一个单元格，如果没有合并，就拿下面这个单元格的col
        if(direction == "bottom" ){
            // for(let r=1;r<this.trs.length-row;r++){
            //     if(this.trs[col+r].tds[r].rowspan !== 0){
            //         nextCol=r;
            //     }
            // }
            for(let r=row+1;r<this.trs.length;r++){
                let have=false;
                for(let s=0;s<this.trs[r].tds.length;s++){
                    if(this.trs[r].tds[s].colIndex==ColIndex){
                        have=true;
                        nextRow=r;
                        nextCol=s;
                        break
                    }
                }
                if(have){
                    break;
                }
            }
        }
        //好像这段可以不要，直接拿当前单元格的rowspan，看看合并了几个单元格，继续往下面在合并一个就可以，如果下面还有单元格的话,但是后面想想，应该要，要拿到这个单元格在下一行的列号
        
        // 这里判断是否有左边的td或者下边的td还要再看看，怎么处理好
        
        if(this.trs[row].tds[col+1] && direction=="right"){
            this.trs[row].tds[col].width+=this.trs[row].tds[col+1].width;
            this.trs[row].tds[col].colspan+=1;
            this.trs[row].tds.splice(col+1,1);
            this.resetAllCellRightSpan();
            
        }else if(direction == "bottom"){
            if(this.trs[nextRow].tds[nextCol].rowspan==1){
                this.trs[row].tds[col].height+=this.trs[nextRow].tds[nextCol].height;
           
                this.trs[nextRow].cols-=1;
                this.trs[nextRow].tds.splice(nextCol,1);
                
                if(this.trs[row].haveCellSpan.length>0){
                    let have=false;
                    for(let a=0;a<this.trs[row].haveCellSpan.length;a++){
                        if(this.trs[row].haveCellSpan[a].colIndex==col && this.trs[row].haveCellSpan[a].rowIndex == row){
                            // this.trs[row].haveCellSpan[a].rowspan+=1;
                            have=true;
                            break;
                        }
                    }
                    if(!have){
                        this.trs[row].haveCellSpan.push({"rowIndex":row,"colIndex":col,"rowspan":this.trs[row].tds[col].rowspan,"isActive":true})
    
                    }
                    
                }else{
                    this.trs[row].haveCellSpan.push({"rowIndex":row,"colIndex":col,"rowspan":this.trs[row].tds[col].rowspan,"isActive":true})
                }
                this.trs[nextRow].haveCellSpan.push({"rowIndex":row,"colIndex":col,"rowspan":this.trs[row].tds[col].rowspan,"isActive":false})
    
                this.trs[row].tds[col].rowspan+=1;
                this.resetCellSpan(row,col);
    
            }else{
                //下一个单元格时合并单元格，然后应该把下一个单元格的这个单元格给这个单元格，然后改变记录合并单元格变量
                this.trs[row].tds[col].height=this.trs[nextRow].tds[nextCol].height;
                this.trs[row].tds[col].rowspan=this.trs[nextRow].tds[nextCol].rowspan+1;
                this.trs[nextRow].tds.splice(nextCol,1);
                this.resetAllCellSpan();

            }
            
            //合并单元格之后要在该单元格所在行留下记录
            //isactive表示他是被动受影响还是主动 被动的话，rowindex存的就是因为哪行而被受影响，主动的话，存的就是自己的值
            

        }
    }
}
export default TableLayout;
//第一列第一行的向下合并三个，第三列从第二行向下合并四个，然后删除前三行，后面两行的合并显示有问题