import layout from './layout';
import FlowLayout from './FlowLayout';

import {Input,Textarea,Radio,Checkbox,Data,Select,Dept,Selectaboutfield,Treedepartmentfield,Userfield,Suggestfield,Button,Viewdialogfield,Tabfield,Calctextfield,Includefield,Surveyfield,Attachment,Imageuploadfield,Onlinetakephotofield,Weixingpsfield,Weixinrecordfield,Qrcodefield,Mapfield,Genericwordfield,Htmleditorfield,Flowhistoryfield,Flowreminderhistoryfield,Informationfeedbackfield} from '../component/index';
import {Sequence} from '../../utility';
class CellLayout extends layout{
    constructor(){
        super();
        this.type="flow";
        this.text="CellLayout";
        this.cursor="default";
        this.element=[];
        this.id=Sequence.createUuid();
        this.scope='CellLayout';
        this.tableClass="CellLayout";
        this.width=null;
        this.height=300;
        this.heightPre=null;
        this.allName=[];
    }
    init(){
        
    }
    paint(){
        let h=`<div><f-clayout id="`+
            this.id+
            `" `+
            `class="`+
            `inlineBlock`+
            `"`+
            `style="`+
            `min-width:`+
            this.width+
            `px;`+
            `min-height:`+
            this.height+
            `px;`+
            `border:1px solid #ccc;"`+
            
            `>`;
            if(this.element.length>0){
                for(let i=0;i<this.element.length;i++){
                    if(this.element[i].scope!="CellLayout" && this.element[i].scope!="FlowLayout"){
                        h+="<p>"
                        h+=this.element[i].paint();
                        h+="</p>"
                    }else{
                        h+=this.element[i].paint();
                    }
                    
                }
            }
            h=h+`</f-clayout></div>`;
        return h;
    }
    parseHtml(html){
        let root=$(html)[0];
        //样式
        // console.log(style);
        let obj={};
        
        for(let key in root.attributes){
            switch(root.attributes[key].name){
                case "style":
                    let style=root.attributes[root.attributes[key].name].value;

                    do{
                        
                        let i=style.indexOf(":");
                        let key2 = style.slice(0,i);
                        style=style.slice(i+1);
            
                        let j=style.indexOf(";");
                        let val=style.slice(0,j);
                        style=style.slice(j+1);
                        if(key2=="min-width"){
                            obj["width"]=parseFloat(val);
                        }else if(key2=="min-height"){
                            obj["height"]=parseFloat(val);
                        }else{
                            obj[key2]=val;
                        }
            
                    }while(style.length!=0);
                break;
                default:
                    if(root.attributes[key].name&&root.attributes[key].value)
                    obj[root.attributes[key].name]=root.attributes[key].value;
                break;
            }
        }
        const traversalNode = (htmlNode) => {
            const {tagName}=htmlNode;
            switch(tagName){
                case 'P':
                    let root2=htmlNode;
                    const traversalNode2 = (htmlNode2) => {
                        const type=htmlNode2.getAttribute("type");
                        switch(type){
                            case 'TABLE':
                                let tablelayout = new TableLayout();
                                tablelayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                tablelayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                tablelayout.x=parseFloat(htmlNode2.getAttribute("panelx"));
                                tablelayout.y=parseFloat(htmlNode2.getAttribute("panely"));
                                tablelayout.parseHtml(htmlNode2);
                                break;
                            case 'F-FLAYOUT':
                                let flowLayout = new FlowLayout();
                                flowLayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                flowLayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                flowLayout.parseHtml(htmlNode2);
                                this.element.push(flowLayout);
                                this.allName=[...this.allName,...flowLayout.getAllName()]
                                break;
                            case 'F-CLAYOUT':
                                let cellLayout = new CellLayout();
                                cellLayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                cellLayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                cellLayout.parseHtml(htmlNode2);
                                this.element.push(cellLayout);
                                this.allName=[...this.allName,...cellLayout.getAllName()]

                                break;
                            case 'f-input':
                                let inputtype=htmlNode2.children[1].getAttribute("classname")
                                switch(inputtype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.DateField":
                                        let data = new Data();
                                        data.parseHtml(htmlNode2);
                                        data.isblock="false";
                                        this.element.push(data);
                                        this.allName.push({"name":data.name,"value":data.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.RadioField":
                                        let radio = new Radio();
                                        radio.parseHtml(htmlNode2);
                                        radio.isblock="true";
                                        this.element.push(radio);
                                        this.allName.push({"name":radio.name,"value":radio.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.CheckboxField":
                                        let checkbox = new Checkbox();
                                        checkbox.parseHtml(htmlNode2);
                                        checkbox.isblock="true";
                                        this.element.push(checkbox);
                                        this.allName.push({"name":checkbox.name,"value":checkbox.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SuggestField":
                                        let suggestfield = new Suggestfield();
                                        suggestfield.parseHtml(htmlNode2);
                                        suggestfield.isblock="false";
                                        this.element.push(suggestfield);
                                        this.allName.push({"name":suggestfield.name,"value":suggestfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.ButtonField":
                                        let button = new Button();
                                        button.parseHtml(htmlNode2);
                                        button.isblock="true";
                                        this.element.push(button);
                                        this.allName.push({"name":button.name,"value":button.fieldtype})
                                        break; 
                                    default:
                                        let input = new Input();
                                        input.parseHtml(htmlNode2);
                                        input.isblock="true";
                                        this.element.push(input);
                                        this.allName.push({"name":input.name,"value":input.fieldtype})
                                        break;
                                }
                                break;
                            case 'f-textarea':
                                let textarea = new Textarea();
                                textarea.parseHtml(htmlNode2);
                                textarea.isblock="true";
                                this.element.push(textarea);
                                this.allName.push({"name":textarea.name,"value":textarea.fieldtype})
                                break;
                            
                            case 'f-select':
                                let selecttype=htmlNode2.getAttribute("classname");
                                switch(selecttype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.DepartmentField":
                                        let dept = new Dept();
                                        dept.parseHtml(htmlNode2);
                                        dept.isblock="false";
                                        this.element.push(dept);
                                        this.allName.push({"name":dept.name,"value":dept.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SelectAboutField":
                                        let selectaboutfield = new Selectaboutfield();
                                        selectaboutfield.parseHtml(htmlNode2);
                                        selectaboutfield.isblock="false";
                                        this.element.push(selectaboutfield);
                                        this.allName.push({"name":selectaboutfield.name,"value":selectaboutfield.fieldtype})
            
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.TreeDepartmentField":
                                        let treedepartmentfield = new Treedepartmentfield();
                                        treedepartmentfield.parseHtml(htmlNode2);
                                        treedepartmentfield.isblock="false";
                                        this.element.push(treedepartmentfield);
                                        this.allName.push({"name":treedepartmentfield.name,"value":treedepartmentfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.UserField":
                                        let userfield = new Userfield();
                                        userfield.parseHtml(htmlNode2);
                                        userfield.isblock="false";
                                        this.element.push(userfield);
                                        this.allName.push({"name":userfield.name,"value":userfield.fieldtype})
                                        break; 
                                    default:
                                        let select = new Select();
                                        select.parseHtml(htmlNode2);
                                        select.isblock="false";
                                        this.element.push(select);
                                        this.allName.push({"name":select.name,"value":select.fieldtype})
            
            
                                        break;
                                }
                                break;
                            
                            case 'f-img':
                                let imgtype=htmlNode2.getAttribute("classname")                                
                                switch(imgtype){
                                    case "cn.myapps.runtime.dynaform.form.ejb.TabField":
                                        let tabfield = new Tabfield();
                                        tabfield.parseHtml(htmlNode2);
                                        tabfield.isblock="true";
                                        this.element.push(tabfield);
                                        this.allName.push({"name":tabfield.name,"value":tabfield.fieldtype})
                
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.ViewDialogField":
                                        let viewdialogfield = new Viewdialogfield();
                                        viewdialogfield.parseHtml(htmlNode2);
                                        viewdialogfield.isblock="true";
                                        this.element.push(viewdialogfield);
                                        this.allName.push({"name":viewdialogfield.name,"value":viewdialogfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.CalctextField":
                                        let calctextfield = new Calctextfield();
                                        calctextfield.parseHtml(htmlNode2);
                                        calctextfield.isblock="true";
                                        this.element.push(calctextfield);
                                        this.allName.push({"name":calctextfield.name,"value":calctextfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.IncludeField":
                                        let includefield = new Includefield();
                                        includefield.parseHtml(htmlNode2);
                                        includefield.isblock="true";
                                        this.element.push(includefield);
                                        this.allName.push({"name":includefield.name,"value":includefield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.SurveyField":
                                        let surveyfield = new Surveyfield();
                                        surveyfield.parseHtml(htmlNode2);
                                        surveyfield.isblock="true";
                                        this.element.push(surveyfield);
                                        this.allName.push({"name":surveyfield.name,"value":surveyfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.AttachmentUploadField":
                                        let attachment = new Attachment();
                                        attachment.parseHtml(htmlNode2);
                                        attachment.isblock="true";
                                        this.element.push(attachment);
                                        this.allName.push({"name":attachment.name,"value":attachment.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.ImageUploadField":
                                        let imageuploadfield = new Imageuploadfield();
                                        imageuploadfield.parseHtml(htmlNode2);
                                        imageuploadfield.isblock="true";
                                        this.element.push(imageuploadfield);
                                        this.allName.push({"name":imageuploadfield.name,"value":imageuploadfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.OnLineTakePhotoField":
                                        let onlinetakephotofield = new Onlinetakephotofield();
                                        onlinetakephotofield.parseHtml(htmlNode2);
                                        onlinetakephotofield.isblock="true";
                                        this.element.push(onlinetakephotofield);
                                        this.allName.push({"name":onlinetakephotofield.name,"value":onlinetakephotofield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.WeixinGpsField":
                                        let weixingpsfield = new Weixingpsfield();
                                        weixingpsfield.parseHtml(htmlNode2);
                                        weixingpsfield.isblock="true";
                                        this.element.push(weixingpsfield);
                                        this.allName.push({"name":weixingpsfield.name,"value":weixingpsfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.WeixinRecordField":
                                        let weixinrecordfield = new Weixinrecordfield();
                                        weixinrecordfield.parseHtml(htmlNode2);
                                        weixinrecordfield.isblock="true";
                                        this.element.push(weixinrecordfield);
                                        this.allName.push({"name":weixinrecordfield.name,"value":weixinrecordfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.QRCodeField":
                                        let qrcodefield = new Qrcodefield();
                                        qrcodefield.parseHtml(htmlNode2);
                                        qrcodefield.isblock="true";
                                        this.element.push(qrcodefield);
                                        this.allName.push({"name":qrcodefield.name,"value":qrcodefield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.MapField":
                                        let mapfield = new Mapfield();
                                        mapfield.parseHtml(htmlNode2);
                                        mapfield.isblock="true";
                                        this.element.push(mapfield);
                                        this.allName.push({"name":mapfield.name,"value":mapfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.GenericWordField":
                                        let genericwordfield = new Genericwordfield();
                                        genericwordfield.parseHtml(htmlNode2);
                                        genericwordfield.isblock="true";
                                        this.element.push(genericwordfield);
                                        this.allName.push({"name":genericwordfield.name,"value":genericwordfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.HTMLEditorField":
                                        let htmleditorfield = new Htmleditorfield();
                                        htmleditorfield.parseHtml(htmlNode2);
                                        htmleditorfield.isblock="true";
                                        this.element.push(htmleditorfield);
                                        this.allName.push({"name":htmleditorfield.name,"value":htmleditorfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.FlowHistoryField":
                                        let flowhistoryfield = new Flowhistoryfield();
                                        flowhistoryfield.parseHtml(htmlNode2);
                                        flowhistoryfield.isblock="true";
                                        this.element.push(flowhistoryfield);
                                        this.allName.push({"name":flowhistoryfield.name,"value":flowhistoryfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.FlowReminderHistoryField":
                                        let flowreminderhistoryfield = new Flowreminderhistoryfield();
                                        flowreminderhistoryfield.parseHtml(htmlNode2);
                                        flowreminderhistoryfield.isblock="true";
                                        this.element.push(flowreminderhistoryfield);
                                        this.allName.push({"name":flowreminderhistoryfield.name,"value":flowreminderhistoryfield.fieldtype})
                                        break;
                                    case "cn.myapps.runtime.dynaform.form.ejb.InformationFeedbackField":
                                        let informationfeedbackfield = new Informationfeedbackfield();
                                        informationfeedbackfield.parseHtml(htmlNode2);
                                        informationfeedbackfield.isblock="true";
                                        this.element.push(informationfeedbackfield);
                                        this.allName.push({"name":informationfeedbackfield.name,"value":informationfeedbackfield.fieldtype})
                                        break;
                                    default:
                                        break;
                                }
                                break;
                            default:
                                console.log("no2");
                                break;

                        }
                    }
                    if(root2.hasChildNodes()) {
                        for(let k = 0;k < root2.children.length;k++) {
                            traversalNode2(root2.children[k]);
                        }
                    }
                    break;
                case 'DIV':
                    let div=htmlNode;
                    const traversalNode3 = (htmlNode3) => {
                        const {tagName}=htmlNode3;
                        switch(tagName){
                            case 'TABLE':
                                let tablelayout = new TableLayout();
                                tablelayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                tablelayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                tablelayout.x=parseFloat(htmlNode2.getAttribute("panelx"));
                                tablelayout.y=parseFloat(htmlNode2.getAttribute("panely"));
                                tablelayout.parseHtml(htmlNode2);
                                break;
                            case 'F-FLAYOUT':
                                let flowLayout = new FlowLayout();
                                flowLayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                flowLayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                flowLayout.parseHtml(htmlNode3);
                                this.element.push(flowLayout);
                                this.allName=[...this.allName,...flowLayout.getAllName()]
                                break;
                            case 'F-CLAYOUT':
                                let cellLayout = new CellLayout();
                                cellLayout.width=parseFloat(htmlNode2.getAttribute("width"));
                                cellLayout.height=parseFloat(htmlNode2.getAttribute("height"));
                                cellLayout.parseHtml(htmlNode3);
                                this.element.push(cellLayout);
                                this.allName=[...this.allName,...cellLayout.getAllName()]

                                break;
                            default:
                                console.log("no");
                                break;
            
                        }
                    }
                    if(div.hasChildNodes()) {
                        for(let a = 0;a < div.children.length;a++) {
                            traversalNode3(div.children[a]);
                        }
                    }
                    break;
                default:
                    console.log("no");
                    break;

            }
        }
        if(root.hasChildNodes()) {
            for(let a = 0;a < root.children.length;a++) {
                traversalNode(root.children[a]);
            }
        }
        this.setProps(obj);
        this.resetChunkElemPosition();
        console.log(obj)
    }
    getNodeConfigInfo(){
        let node = {};
		node.text = this.text;
		node.icon = 'glyphicon glyphicon-hand-right';
		node.uuid = this.id;	
        node.instance = this;
        if(this.element.length > 0) {
			node.nodes = []
			for(let i = 0, len = this.element.length;i < len;i++) {
				const data = this.element[i].getNodeConfigInfo();
				node.nodes.push(data);	
			}
		}
		return node;
    }
    addElement(elem){
        // elem.width=this.width;
        if(elem.scope!="CellLayout" && elem.scope!="FlowLayout" ){
            elem.isblock="true";
            elem.preWidth=elem.width;
            elem.width=this.width;
        }
        
        this.element.push(elem);
        return false;
    }
    resetElementToChunk(){

    }
    resetChunkElemPosition(){
        let x=this.x,y=this.y;
        let bigHeight=0;
        for(let i=0;i<this.element.length;i++){
            if(bigHeight<this.element[i].height)bigHeight=this.element[i].height+this.element[i].margintop+this.element[i].marginbottom;
            this.element[i].x=x;this.element[i].y=y;
            if(this.element[i].scope=="FlowLayout" || this.element[i].scope=="CellLayout"){
                this.element[i].resetChunkElemPosition();
            }
            x+=this.element[i].width;
            
            if(this.element[i+1]){
                if(this.element[i+1].width+x>this.width){
                    
                    x=0;y=bigHeight+this.element[i].y;
                    bigHeight=0;
                }
            }
        }
    }
    //对于新加进布局的元素，设置x，y值
    setElementPosition(elem){
        let x=this.width,y=0;
        for(let i=0;i<this.element.length;i++){
            y+=this.element[i].height+this.element[i].marginbottom+this.element[i].margintop;
        }
        if(y+elem.height>this.height-20){
            let h=this.height*1.2<y+elem.height?y+elem.height+this.height*0.2:this.height*1.2
            this.height=h;
        }
        return {
            x:x,
            y:y,
        }
        
    }
    //判断当前鼠标按下的位置是否在该布局下的元素内,这个方法是给鼠标按下出现属性面板事件用的，主要是获取最底层一级的非布局或者布局元素
    selectedElement(x,y){
        let currentElem=null;

        for(let i=0;i<this.element.length;i++){
            if(this.element[i].x-5<x && this.element[i].x+this.element[i].width+5>x && this.element[i].y-5<y && this.element[i].y+this.element[i].height+5>y){
                if(this.element[i].scope!="FlowLayout" && this.element[i].scope!="CellLayout"){
                    if(this.element[i].scope=="textarea"){
                        //单独对多行文本框进行判断，是否在多行文本框的右下角边线上，如果有的话，那当前就没有选中元素
                        if(this.element[i].isOnBaseLine(x,y)){
                            return false;
                        }else{
                            return this.element[i];
                        }
                    }else{
                        return this.element[i];
                    }
                }else{
                    currentElem = this.element[i].selectedElement(x,y);
                }
            }

        }
        if(currentElem){
            return currentElem;
        }else{
            return null;
        }
    }
    //获取选中的布局,这个主要是给布局内布局放置元素用，获取当前布局内布局
    getSelectedElem(x,y){
        let length = this.element.length,currentChunk=null;
        for(let j=0;j<length;j++){
            if(this.element[j].scope=="FlowLayout" || this.element[j].scope=="CellLayout"){
                if(this.element[j].x-5<x&&this.element[j].x+this.element[j].width+5>x&&this.element[j].y-5<y&&this.element[j].y+this.element[j].height+5>y){
                    if(this.element[j].element.length>0){
                        currentChunk=this.element[j].getSelectedElem(x,y);
                    }else{
                        return this.element[j];
                    }
                }  
            }
            
        }
        if(currentChunk){
            return currentChunk;
        }else{
            return this;
        }
    }
    //判断鼠标按下的点是否在元素变线或者元素下元素边线

    isOnBaseLine(x,y){
        let currentChunk=null;
        if( this.y+this.height-5<y && this.y+this.height+5>y){
            return this;
        }
        for(let i=0;i<this.element.length;i++){
            if(currentChunk){
                return currentChunk;
            }
            if(this.element[i].y+this.element[i].height-5<y && this.element[i].y+this.element[i].height+5>y){
                //判断是否在子元素的边线上,在子元素边线上，然后判断是否是flow布局，是的话返回这个布局，不是的话判断是不是多行文本框，判断是不是在多行文本框的边线
                if(this.element[i].scope!="FlowLayout" || this.element[i].scope!="CellLayout"){
                    if(this.element[i].scope=="textarea"){
                        currentChunk = this.element[i].isOnBaseLine(x,y);
                    }else{
                        return this.element[i];
                    }
                }else{
                    currentChunk = this.element[i].isOnBaseLine(x,y);
                }
            }else if(this.element[i].x<x && this.element[i].x+this.element[i].width>x && this.element[i].y<y && this.element[i].y+this.element[i].height>y){
                //如果不在子元素边线上，判断是不是在子元素范围内,再看子元素是不是布局元素，如果是的话要对布局元素内的元素进行边线判断
                if(this.element[i].element && this.element[i].element.length>0){
                    for(let j=0;j<this.element[i].element.length;j++){
                        if(this.element[i].element[j].scope!="FlowLayout" ||this.element[i].element[j].scope!="CellLayout"){
                            if(this.element[i].element[j].scope=="textarea"){
                                currentChunk = this.element[i].element[j].isOnBaseLine(x,y);
                            }else{
                                return null;
                            }
                        }else{
                            currentChunk = this.element[i].isOnBaseLine(x,y);
                        }
                    }
                }
            }

        }
        if(currentChunk){
            return currentChunk;
        }else{
            return null;
        }
    }
    
    delElem(_currentElemId){
        let delElm=null;
        for(let j=0;j<this.element.length;j++){
            if(this.element[j].id==_currentElemId){
                delElm=this.element[j];
                this.element.splice(j,1);
                // this._currentElemId=null;

                break;
            }else if(this.element[j].element && this.element[j].element.length>0){
                delElm=this.element[j].delElem(_currentElemId);
            }
        }
        if(delElm){
            return delElm;
        }else{
            return false;
        }
    }
    deleteElem(elemId){
        let name=null;
        for(let j=0;j<this.element.length;j++){
            if(this.element[j].id==elemId){
                name=this.element[j].name;
                this.element.splice(j,1);
                // this._currentElemId=null;

                break;
            }else if(this.element[j].element && this.element[j].element.length>0){
                name=this.element[j].deleteElem(elemId);
            }
        }
        if(name){
            return name;
        }else{
            return false;
        }
    }
    addElem(_currentChunkId,delElm){
        let back=false;
        for(let b=0;b<this.element.length;b++){
            if(this.element[b].id==_currentChunkId){
                if(this.element[b].scope=="FlowLayout"){
                    delElm.isblock="false";
                }else if(this.element[b].scope=="CellLayout"){
                    delElm.isblock="true";
                    delElm.preWidth=delElm.width;
                    delElm.width=this.width;
                }
                this.element[b].element.push(delElm);
                back=true;
                
            }else if(this.element[b].element && this.element[b].element.length>0){
                back=this.element[b].element.addElem(_currentChunkId,delElm);
            }
        }
        if(back){
            return back;
        }
    }
    //判断子元素是否是符合条件的布局元素
    elemIsChunk(_currentChunkId){
        let isChunk=false;
        for(let b=0;b<this.element.length;b++){
            if(this.element[b].id==_currentChunkId && (this.element[b].scope=="FlowLayout" || this.element[b].scope=="CellLayout" )){   
                isChunk=true;
            }else if(this.element[b].element && this.element[b].element.length>0){
                isChunk=this.element[b].elemIsChunk(_currentChunkId);
            }
        }
        return isChunk;
    }
    getAllName(){
        return this.allName;
    }
    getallDeptName(){
        let allDeptName={};
        for(let i=0;i<this.element.length;i++){
            if(this.element[i].scope=="dept"){
                //let data={}
                allDeptName[this.element[i].name]="false";
                //allDeptName.push(data)
            }else if(this.element[i].scope=="FlowLayout"|| this.element[i].scope=="CellLayout" ){
                allDeptName={ ...allDeptName, ...this.element[i].getallDeptName()}

            }
        }
        return allDeptName
    }
    setAllProcesspreValue(h){
        for(let i=0;i<this.element.length;i++){
            if(this.element[i].scope!="FlowLayout" && this.element[i].scope!="CellLayout"){
                this.element[i].processprevalue=h;
            }else{
                this.element[i].setAllProcesspreValue(h);
            }
        }
    }
    getElementLength(){
        return this.element.length;
    }
    //重置所有非布局元素的ischeked属性为false
    resetisCheck(){
        for(let i=0;i<this.element.length;i++){
            if(this.element[i].scope!="FlowLayout" && this.element[i].scope!="CellLayout"){
                this.element[i].isChecked=false;
            }else{
                this.element[i].resetisCheck();
            }
        }
    }
}
export default CellLayout;