import { FormPanel, PropsPanel, Tree } from "./form/view";
import { Api, HTMLOperate, StringUtil } from "./utility";
class FormApp {
  constructor(panel, container) {
    this.panel = panel;
    this.container = container;
    this.form = null;
  }
  Init() {
    //在这里进行表单进行初始化
    let api = new Api();
    let htmlhandle = new HTMLOperate(this.form);

    let html = "";
    $.when(api.getHtml()).done(data => {
      html = data.demo.data;
      console.log(
        StringUtil.dencodeHTML(
          "[{@quot;text@quot;:@#146;ces@#146;,@quot;value@quot;:@#146;VALUE_TYPE_VARCHAR@#146;},{@quot;text@quot;:@#146;ces3@#146;,@quot;value@quot;:@#146;VALUE_TYPE_VARCHAR@#146;}];[ces]"
        )
      );

      html = StringUtil.dencodeHTML(html);
      html = htmlhandle.hadleHtml(html);

      console.log(html);
      $(this.panel).html(html);
      this.form.parseHtml($(this.panel));
    });
    this.initFormPanel(this.panel);
    this.registerEvent();
    this.form.width = $(this.panel).width();
    this.initTree(this.form);
    this.initPropPanel($("#propsBoard"));
  }
  initFormPanel(panel) {
    if (panel) {
      this.form = new FormPanel(panel);
      this.form.init(this.form);
    }
  }
  initTree(form) {
    const treeDiv = this.container.find("#tree");
    const tree = Tree.getInstance();
    tree.init(treeDiv, form);
  }

  initPropPanel($container) {
    const propsPanel = PropsPanel.getInstance();

    propsPanel.init({ container: $container, form: this.form || null });
  }
  renderPropsPanel() {
    const propsPanel = PropsPanel.getInstance();

    propsPanel.render();
  }

  registerEvent() {
    const $container = $(this.container);
    let htmlhandle = new HTMLOperate(this.form);
    const panel = this.panel;
    const form = this.form;
    const $component = $container.find("#component");
    const $diagramFlow = $container.find("#diagramFlow");
    $component.on("mousedown", "#Input", () => {
      console.log("input");
      form.addInput();
    });

    $component.on("mousedown", "#Textarea", () => {
      console.log("Textarea");
      form.addTextarea();
    });
    $component.on("mousedown", "#Radio", () => {
      console.log("radio");
      form.addRadio();
    });
    $component.on("mousedown", "#Checkbox", () => {
      console.log("checkbox");
      form.addCheckbox();
    });
    $component.on("mousedown", "#Data", () => {
      console.log("checkbox");
      form.addData();
    });
    $component.on("mousedown", "#Select", () => {
      console.log("checkbox");
      form.addSelect();
    });
    $component.on("mousedown", "#Dept", () => {
      console.log("Dept");
      form.addDept();
    });
    $component.on("mousedown", "#Selectaboutfield", () => {
      console.log("Selectaboutfield");
      form.addSelectaboutfield();
    });
    $component.on("mousedown", "#Treedepartmentfield", () => {
      console.log("Treedepartmentfield");
      form.addTreedepartmentfield();
    });
    $component.on("mousedown", "#Userfield", () => {
      console.log("Userfield");
      form.addUserfield();
    });
    $component.on("mousedown", "#Suggestfield", () => {
      console.log("Suggestfield");
      form.addSuggestfield();
    });
    $component.on("mousedown", "#Button", () => {
      console.log("button");
      form.addButton();
    });
    $component.on("mousedown", "#Viewdialogfield", () => {
      console.log("Viewdialogfield");
      form.addViewdialogfield();
    });
    $component.on("mousedown", "#Tabfield", () => {
      console.log("Tabfield");
      form.addTabfield();
    });
    $component.on("mousedown", "#Calctextfield", () => {
      console.log("Calctextfield");
      form.addCalctextfield();
    });
    $component.on("mousedown", "#Includefield", () => {
      console.log("Includefield");
      form.addIncludefield();
    });
    $component.on("mousedown", "#Surveyfield", () => {
      console.log("Surveyfield");
      form.addSurveyfield();
    });
    $component.on("mousedown", "#Attachment", () => {
      console.log("Attachment");
      form.addAttachment();
    });
    $component.on("mousedown", "#Imageuploadfield", () => {
      console.log("Imageuploadfield");
      form.addImageuploadfield();
    });
    $component.on("mousedown", "#Onlinetakephotofield", () => {
      console.log("Onlinetakephotofield");
      form.addOnlinetakephotofield();
    });
    $component.on("mousedown", "#Weixingpsfield", () => {
      console.log("Weixingpsfield");
      form.addWeixingpsfield();
    });
    $component.on("mousedown", "#Weixinrecordfield", () => {
      console.log("Weixinrecordfield");
      form.addWeixinrecordfield();
    });
    $component.on("mousedown", "#Qrcodefield", () => {
      console.log("Qrcodefield");
      form.addQrcodefield();
    });
    $component.on("mousedown", "#Mapfield", () => {
      console.log("Mapfield");
      form.addMapfield();
    });
    $component.on("mousedown", "#Genericwordfield", () => {
      console.log("Genericwordfield");
      form.addGenericwordfield();
    });
    $component.on("mousedown", "#Htmleditorfield", () => {
      console.log("Htmleditorfield");
      form.addHtmleditorfield();
    });
    $component.on("mousedown", "#Flowhistoryfield", () => {
      console.log("Flowhistoryfield");
      form.addFlowhistoryfield();
    });
    $component.on("mousedown", "#Flowreminderhistoryfield", () => {
      console.log("Flowreminderhistoryfield");
      form.addFlowreminderhistoryfield();
    });
    $component.on("mousedown", "#Informationfeedbackfield", () => {
      console.log("Informationfeedbackfield");
      form.addInformationfeedbackfield();
    });


    $component.on("mousedown", "#TableLayout", () => {
      //console.log("TableLayout");
      form.addTableLayout();
    });

    $component.on("mousedown", "#FlowLayout", () => {
      //console.log("TableLayout");
      form.addFlowLayout();
    });
    $component.on("mousedown", "#CellLayout", () => {
      //console.log("TableLayout");
      form.addCellLayout();
    });
    $("#save").click(function() {
      let html = $(panel).html();
      html = htmlhandle.toHtml(html);
      console.log("转码前", html);
      html = StringUtil.encodeHTML(html);
      console.log(html);
    });
    $diagramFlow.off("click").on("click", e => {
      if ($(e.target).attr("id") == "diagramFlow") {
        //清空正在编辑的元素和区域
        form.clearCurrToEdit();
      }
      console.log("外层");
      e.stopPropagation();
      this.renderPropsPanel();
      return false;
    });
    $diagramFlow.off("drop").on("drop", () => {
      let ev = window.event || arguments.callee.caller.arguments[0];
      ev.preventDefault();
      ev.stopPropagation();
      var data = ev.dataTransfer.getData("Text");
      ev.target.appendChild(document.getElementById(data));
      form._currentChunkId = ev.target.id;
      form._currentElemId = data;
      form.resetElementChunk();
      form.repaint();
    });
    $component.on("click", e => {
      return false;
    });
  }
}
export const render = (panel, container) => {
  new FormApp(panel, container).Init();
};
