# **myApps平台App接口说明文档 V1.0**

## 1.  **用户**

### 1.1获取企业域列表

**请求方式：** GET  
**请求地址：** /runtime/app/domains/list.action

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| 无       | 否       |          |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "uuid",
            "name": "无限极公司"
        }
    ]
}

```

**参数说明：**

| **参数**     | **说明**                 |
|--------------|--------------------------|
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 1.2用户登录
--------

**请求方式：** POST  
**请求地址：** /runtime/app/security/login.action

**请求包体：**

```
{
    "domainName": "无限极公司",
    "username": "test",
    "password": "123456",
    "checkcode": "1234"
}

```

**参数说明：**

| **参数**   | **必须** | **说明**   |
|------------|----------|------------|
| domainName | 是       | 企业域名称 |
| username   | 是       | 账号       |
| password   | 是       | 密码       |
| checkcode  | 否       | 验证码     |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": {
        "username": "测试账号",
        "mobile2": "12345123563",
        "email": "3426143645@qq.com",
        "department": "11e1-81e2-afbbfc08-9124-47aada6b7467",
        "userId": "11e7-bed7-aff20845-87b6-fb8170f92bdc",
        "domain": "我的公司",
        "avatar": "http://shp.qpic.cn/bizmp/c2SNvgUbuacFutC1zGdEiaPribuWVrkk0vlt1aEkaMVFPYITus9relog/",
        "loginno": "abc01",
        "access_token": "92c797758a5489fea358266b518d8dda82cdb80caea457547a0c4d8219a7894f1b4d7a22ba52842550565445e8bf505038141d462c7961a670d14757e30b1dd70bf52e3f0acedca6896d3a9f5da89e6c3fc8622087dbdc5258af2947bb6d9560ffd39e21399cbeafd9019bd373611533",
        "mobile": "12345678901"
    }
}

```

**参数说明：**

| **参数**           | **说明**                                                                            |
|--------------------|-------------------------------------------------------------------------------------|
| errcode            | 返回码（0=登录成功，1=账号或密码错误）                                              |
| errmsg             | 状态码对应的信息文本                                                                |
| data               | 用户访问凭证                                                                        |
| data. access_token | 用户访问凭证，大部分API调用需要access_token才能访问，一个access_token对应一个用户。 |

### 1.3 图片验证码获取
--------------

当登陆失败超过3次的时候,登陆接口会返回showCode字段,获取验证码

**请求方式：** GET  
**请求地址：** /checkCodeImg

**权限说明：**

无。

### 1.4 单点登录
--------

**请求方式：** POST  
**请求地址：{**http://192.168.80.177:8080**}**/portal/phone/main.jsp?application={applicationId}&mode=app&access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明** |
|--------------|----------|----------|
| application  | 是       | 软件id   |
| mode         | 是       | 模块     |
| access_token | 是       | 令牌     |

**权限说明：**

access_token在登陆的时候会生成唯一的，一个月的有效期。

### 1.5 获取用户资料
------------

**请求方式：** GET  
**请求地址：**/runtime/app/users/queryUser.action?access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": {
        "id": "11e7-7045-31a4aecf-85f9-cbfc8973e987",
        "name": "张三",
        "loginno": "zhangsan",
        "email": "shangsan@qq.com",
        "mobile": "13414523456",
        "mobile2": "13414523453",
        "avatar": "http://shp.qpic.cn/bizmp/wD4d11FtibicHlEvR4DovbkiaIPFvzOZf3u1fG5Bw7ibUrR1rwDs1KWLbg/",
        "domain": "无限极公司",
        "department": "售后服务部"
    }
}

```

**参数说明：**

| **参数**        | **说明**                 |
|-----------------|--------------------------|
| errcode         | 返回码（0-成功，1=失败） |
| errmsg          | 状态码对应的信息文本     |
| data            | 用户基本信息             |
| data.id         | 主键                     |
| data.name       | 用户名称                 |
| data. loginno   | 账号                     |
| data.email      | 邮箱                     |
| data. telephone | 手机号                   |
| data.telephone2 | 手机号2                  |
| data.avatar     | 用户头像地址             |
| data.domain     | 所属企业域名称           |
| data.department | 所属部门名称（默认）     |

### 1.6 获取联系人资料
--------------

可获取多个联系人资料

**请求方式：** GET  
**请求地址：** /runtime/app/users/getUser.action?access_token={access_token}&ids={ids}

**参数说明：**

| **参数**     | **必须** | **说明**                            |
|--------------|----------|-------------------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2           |
| ids          | 是       | 联系人主键(多个联系人用逗号","隔开) |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [{
        "id": "11e7-7045-31a4aecf-85f9-cbfc8973e987",
        "name": "张三",
        "loginno": "zhangsan",
        "email": "shangsan@qq.com",
        "mobile": "13414523456",
        "mobile2": "13414523453",
        "avatar": "http://shp.qpic.cn/bizmp/wD4d11FtibicHlEvR4DovbkiaIPFvzOZf3u1fG5Bw7ibUrR1rwDs1KWLbg/",
        "domain": "无限极公司",
        "department": "售后服务部",
        "favoriteContact": true
    }]
}

```

**参数说明：**

| **参数**                | **说明**                 |
|-------------------------|--------------------------|
| errcode                 | 返回码（0-成功，1=失败） |
| errmsg                  | 状态码对应的信息文本     |
| data                    | 用户基本信息集合         |
| data[0].id              | 主键                     |
| data[0].name            | 用户名称                 |
| data[0]. loginno        | 账号                     |
| data[0].email           | 邮箱                     |
| data[0]. telephone      | 手机号                   |
| data[0].telephone2      | 手机号2                  |
| data[0].avatar          | 用户头像地址             |
| data[0].domain          | 所属企业域名称           |
| data[0].department      | 所属部门名称（默认）     |
| data[0].favoriteContact | 是否常用联系人           |

### 1.7 更新用户资料
------------

**请求方式：** POST  
**请求地址：** /runtime/app/users/save.action?access_token={access_token}

**请求包体：**

```
{
"avatar": "",
    "name": "张三",
    "loginno": "zhangsan",
    "password": "abc123456",
    "email": "shangsan@qq.com",
    "mobile": "13414523453",
    "mobile2": "13414523453",
    "oldPassword": "13414523453"
}

```

**参数说明：**

| **参数**     | **必须** | **说明**                            |
|--------------|----------|-------------------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2           |
| 请求包体     | 是       | 用户基本信息对象，数据结构参考\#1.3 |

**权限说明：**

无。

**返回结果：**

```
{  
  "errcode" : 0,  
  "errmsg" : "保存成功",
  "data" : null 
}

```

**参数说明：**

| **参数** | **说明**             |
|----------|----------------------|
| errcode  | 返回码               |
| errmsg   | 状态码对应的信息文本 |
| data     | 无                   |

## 2.  **事项通知**

### 2.1  获取通知

**请求方式：** GET  
**请求地址：** /runtime/app/notice/list.action?access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "uuid",
            "summary": "<span class='....-</span>",
            "toUserId": "uuid",
            "content": {
            "content": "张三申请[事假]2天",
            "event": "发起",
            "type": 3
        }
            "createTime": "2017-9-28",
            "read": false,
            "module": "OA办公",
            "linkParams": {
                "_docid": "11e6-c81d-6c6c6a57-acab-1fbf492f91e2",
                "_formid": "11e6-5fae-3b5b0e16-b3ac-31493634e7af",
                "application":"11de-f053-df18d577-aeb6-19a7865cfdb6",
                "mode": "personalMessageMode"
            },
            "subjectType": 3,
            "messageType": 1
        }
    ]
}

```

**参数说明：**

| **参数**                | **说明**                                                 |
|-------------------------|----------------------------------------------------------|
| errcode                 | 返回码（0=成功，1=失败）                                 |
| errmsg                  | 对返回码的文本描述内容                                   |
| data                    | 通知对象集合                                             |
| data[0].id              | 通知主键                                                 |
| data[0].summary         | 通知内容                                                 |
| data[0].content.content | 通知内容                                                 |
| data[0].content.event   | 通知动作                                                 |
| data[0].content.type    | 通知动作类型                                             |
| data[0]. toUserId       | 通知对象id                                               |
| data[0]. createTime     | 通知日期                                                 |
| data[0]. read           | 是否已读                                                 |
| data[0]. module         | 所属应用模块                                             |
| data[0]. linkParams     | 链接参数                                                 |
| data[0]. subjectType    | 事项类型（1=提交2=回退3=待办4=催办5=过期提醒6=抄送提醒） |
| data[0]. messageType    | 消息类型(1=代办消息 2=文本消息)                          |

### 2.2 标记已读
--------

**请求方式：** GET  
**请求地址：** /runtime/app/notice/read.action?access_token={access_token}&ids={ids}

**请求包体：**

无

**参数说明：**

| **参数**     | **必须** | **说明**                         |
|--------------|----------|----------------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2        |
| ids          | 是       | 事项通知的主键(多个id用逗号隔开) |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 状态码对应的信息文本     |

### 2.3 删除通知
--------

**请求方式：** GET  
**请求地址：** /runtime/app/users/delete.action?access_token={access_token}&id={id}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |
| id           | 是       | 事项通知的主键            |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码（0-成功，1=失败） |
| errmsg   | 状态码对应的信息文本     |

## 3.  **通讯录**

### 3.1 获取通讯录

**请求方式：** GET  
**请求地址：** /runtime/app/contacts/tree.action?access_token={access_token}&
parentId={parentId}

**参数说明：**

| **参数**     | **必须** | **说明**                                 |
|--------------|----------|------------------------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2                |
| parentId     | 否       | 父级部门id，如果参数为空，则获取一级部门 |

**权限说明：**

无。

**返回结果：**

```
{
    "message": "ok",
    "status": 0,
    "data": {
        "datas": [
            {
                "children": [],
                "userCount": 4,
                "id": "11e5-8ea9-7ead9389-b6a8-8959966cbe66",
                "name": "采购部",
                "type": 2
            },
            {
            "id": "uuid",
            "name": "李玲",
            "mobile": "12345678901",
            "mobile": "12345678901",
            "avatar": "",
            "email": "1234744@adb.com",
            "dept": "产品部",
            "domain": "我的公司",
            "type": 1,
            "favoriteContact": true
                    }
                ],
            "count": 39
    }
}

```

**参数说明：**

| **参数**                      | **说明**                 |
|-------------------------------|--------------------------|
| errcode                       | 返回码（0=成功，1=失败） |
| errmsg                        | 对返回码的文本描述内容   |
| data                          | 用户部门集合             |
| data[0].datas.id              | 部门主键                 |
| data[0].datas.name            | 部门名称                 |
| data[0].datas.userCount       | 部门人数统计             |
| data[0].datas. id             | 用户主键                 |
| data[0].datas. name           | 用户名称                 |
| data[0].datas.mobile          | 用户手机号码             |
| data[0].datas.avatar          | 用户头像地址             |
| data[0].datas.email           | 用户邮箱                 |
| data[0].datas.dept            | 用户所属部门             |
| data[0].datas.favoriteContact | 是否常用联系人           |
| data[1].count                 | 总人数统计               |

### 3.1 模糊搜索联系人
--------------

根据用户姓名,首字母,电话号码进行模糊查询

**请求方式：** GET  
**请求地址：** /runtime/app/contacts/getContactsBySearch.action?keyWord={keyWord}&access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |
| keyWord      | 否       | 联系人姓名,首字母,电话    |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "uuid",
            "name": "李玲",
            "mobile": "12345678901",
            "mobile": "12345678901",
            "avatar": "",
            "email": "1234744@adb.com",
            "dept": "产品部",
            "domain": "我的公司",
            "favoriteContact": true
        }
    ]
}

```

**参数说明：**

| **参数**                | **说明**                 |
|-------------------------|--------------------------|
| errcode                 | 返回码（0=成功，1=失败） |
| errmsg                  | 对返回码的文本描述内容   |
| data                    | 用户部门集合             |
| data[0]. id             | 用户主键                 |
| data[0]. name           | 用户名称                 |
| data[0].mobile          | 用户手机号码             |
| data[0].avatar          | 用户头像地址             |
| data[0].email           | 用户邮箱                 |
| data[0].dept            | 用户所属部门             |
| data[0].domain          | 所属企业域               |
| data[0].favoriteContact | 是否常用联系人           |

### 3.3 模糊搜索部门
------------

根据部门名称进行模糊查询

**请求方式：**GET  
**请求地址：**/runtime/app/contacts/getDepartmentsBySearch.action?keyWord={keyWord}&access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |
| keyWord      | 否       | 联系人姓名,首字母,电话    |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
        {
            "children": [],
            "id": "11e1-81e2-a771f18e-9124-47aada6b7467",
            "name": "资讯部",
            "type": 2
        }
    ]
}

```

**参数说明：**

| **参数**     | **说明**                 |
|--------------|--------------------------|
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 用户部门集合             |
| data[0].id   | 部门主键                 |
| data[0].name | 部门名称                 |

### 3.4 模糊搜索联系人和部门
--------------------

根据用户姓名,首字母,电话号码进行模糊查询联系人

根据部门名称进行模糊查询部门

**请求方式：** GET  
**请求地址：** /runtime/app/contacts/getContactsAndDeptsBySearch.action?keyWord={keyWord}&access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |
| keyWord      | 否       | 联系人姓名,首字母,电话    |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
            {
            "id": "uuid",
            "name": "李玲",
            "mobile": "12345678901",
            "mobile": "12345678901",
            "avatar": "",
            "email": "1234744@adb.com",
            "dept": "产品部",
            "domain": "我的公司",
            "favoriteContact": true
        },{
            "children": [],
            "id": "11e1-81e2-a771f18e-9124-47aada6b7467",
            "name": "资讯部",
            "type": 2
        }
    ]
}

```

**参数说明：**

| **参数**                | **说明**                 |
|-------------------------|--------------------------|
| errcode                 | 返回码（0=成功，1=失败） |
| errmsg                  | 对返回码的文本描述内容   |
| data                    | 用户部门集合             |
| data[0]. id             | 用户主键                 |
| data[0]. name           | 用户名称                 |
| data[0].mobile          | 用户手机号码             |
| data[0].avatar          | 用户头像地址             |
| data[0].email           | 用户邮箱                 |
| data[0].dept            | 用户所属部门             |
| data[0].domain          | 所属企业域               |
| data[0].favoriteContact | 是否常用联系人           |
| data[1].id              | 部门主键                 |
| data[1].name            | 部门名称                 |

### 3.5  获取常用联系人
--------------

常用联系人

**请求方式：** GET  
**请求地址：** /runtime/app/contacts/getFavoriteContacts.action?access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |

**权限说明：**

无。

**返回结果：**

```
{
    "message": "ok",
    "status": 0,
    "data": {
        "datas": [
            {
                "avatar":"http://shp.qpic.cn/bizmp/c2SNvgUbuafUJkFIXpKficYxqAtJ9s9brvOgiaTV1KDk7YIgTOvSlflA/",
                "dept": "11e1-81e2-714059a0-9124-47aada6b7467",
                "domain": "我的公司",
                "email": "",
                "id": "11e3-8330-bc935dea-8fcc-95326fa8f055",
                "mobile": "",
                "mobile2": "",
                "name": "肖主管（销售主管）",
                "type": 1
            },
            {
                "avatar": "",
                "dept": "11e6-292f-51466c29-9a78-9b801f3f5251",
                "domain": "我的公司",
                "email": "",
                "id": "11e6-292f-73b25f8e-9a78-9b801f3f5251",
                "mobile": "",
                "mobile2": "",
                "name": "李丽_项目经理",
                "type": 1
            }
        ],
        "count": 2
    }
}

```

**参数说明：**

| **参数**       | **说明**                 |
|----------------|--------------------------|
| errcode        | 返回码（0=成功，1=失败） |
| errmsg         | 对返回码的文本描述内容   |
| data           | 用户部门集合             |
| data[0]. id    | 用户主键                 |
| data[0]. name  | 用户名称                 |
| data[0].mobile | 用户手机号码             |
| data[0].avatar | 用户头像地址             |
| data[0].email  | 用户邮箱                 |
| data[0].dept   | 用户所属部门             |
| data[0].domain | 所属企业域               |
| count          | 联系人数                 |

### 3.6 添加常用联系人
--------------

添加常用联系人

**请求方式：** GET  
**请求地址：** /runtime/app/contacts/addFavoriteContact.action?access_token={access_token}&userId={userId}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |
| userId       | 是       | 联系人主键                |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "添加成功",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | Null                     |

### 3.7 移除常用联系人
--------------

移除常用联系人

**请求方式：** GET  
**请求地址：** /runtime/app/contacts/removeFavoriteContact.action?access_token={access_token}&userId={userId}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |
| userId       | 是       | 联系人主键                |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "移除成功",
    "data": null
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | Null                     |

## 4.  **工作台**

### 4.1 获取应用列表

**请求方式：** GET  
**请求地址：** /runtime/app/applications/list.action?access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "uuid",
            "name": "OA办公",
            "description": "应用描述文字",
            "logourl": {"key","value"},
            "jumpToUrl": {
                "url1": {
                    "name": "待填写",
                    "url": "/qm/wap/pendlist.jsp?application=qm"
                },
                "url2": {
                    "name": "问卷中心",
                    "url": "/qm/wap/center.jsp?application=qm"
                }
            }
        }
    ]
}

```

**参数说明：**

| **参数**             | **说明**                 |
|----------------------|--------------------------|
| errcode              | 返回码（0=成功，1=失败） |
| errmsg               | 对返回码的文本描述内容   |
| data                 | 应用集合                 |
| data[0].id           | 应用id                   |
| data[0].name         | 应用名称                 |
| data[0]. description | 应用描述                 |
| data[0]. logourl     | 图标url                  |
| data[0]. jumpToUrl   | 跳转到应用的 url         |

### 4.2 模糊查询应用
------------

根据应用名称进行模糊查询

**请求方式：** GET  
**请求地址：** /runtime/app/applications/getAppcationsBySearch.action?keyWord={keyWord}&access_token={access_token}

**参数说明：**

| **参数**     | **必须** | **说明**                  |
|--------------|----------|---------------------------|
| access_token | 是       | 访问凭据，获取方式参考1.2 |
| keyWord      | 否       | 关键字（应用名称）        |

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "uuid",
            "name": "OA办公",
            "description": "应用描述文字",
             "logourl": {"key","value"}
   
        }
    ]
}

```

**参数说明：**

| **参数**             | **说明**                 |
|----------------------|--------------------------|
| errcode              | 返回码（0=成功，1=失败） |
| errmsg               | 对返回码的文本描述内容   |
| data                 | 应用集合                 |
| data[0].id           | 应用id                   |
| data[0].name         | 应用名称                 |
| data[0]. description | 应用描述                 |
| data[0]. logourl     | 图标url                  |

### 4.3文件上传
--------

**请求方式：** POST  
**请求地址：** /runtime/app/upload?path={path}&fileSaveMode={fileSaveMode}&fieldId={fieldId}&allowedTypes={allowedTypes}&applicationId={applicationId}

**参数说明：**

| **参数**      | **必须** | **说明**           |
|---------------|----------|--------------------|
| path          | 是       | 上传文件保存的路径 |
| fileSaveMode  | 是       | 文件保存模式       |
| fieldId       | 是       | 表单字段           |
| allowedTypes  | 是       | 允许上传的类型     |
| applicationId | 是       | 软件id             |

**权限说明：**

无。

**返回结果：**

```
[{
"name": "啊啊",
"type": ".xml",
"path": "uuid",
"size": "1024"
}]

```

**参数说明：**

| **参数** | **说明** |
|----------|----------|
| name     | 文件名   |
| type     | 文件类型 |
| path     | 文件路径 |
| size     | 文件大小 |

## 5.  **环信IM**

### 5.1 注册环信用户

**说明：**

**环信IM用户**

**用户名用的是我们平台用户的id（主键）密码默认为123456**

### 5.2 获取环信配置信息
----------------

**请求方式：** GET  
**请求地址：** /runtime/app/hx/config.action

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| 无       | 否       |          |

**权限说明：**

无。

**返回结果：**

```
{
    "message": "ok",
    "status": 0,
    "data": {
        "app_name": "com-tlin-jarod-tlin",
        "client_id": "YXA6kqOBEMNtEeeKPC1YpoCz-A",
        "client_secret": "YXA6-2HmjGsEQutF62F5CviM4jqWsVo",
        "grant_type": "client_credentials",
        "open": "0",
        "org_name": "1180171101178675"
    }
}

```

**参数说明：**

| **参数** | **说明**                 |
|----------|--------------------------|
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 环信配置信息             |

### 5.3 获取控件修改历史

------

**请求方式：** GET  
**请求地址：** /runtime/{applicationId}/documents/{docId}/formhelper/inputlog?fieldName={fieldNmae}

**参数说明：**

​      **作者** **：**ekko



| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| 无       | 否       |          |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,  //返回码
	"errmsg": "ok", //状态
	"data": [{      //数据
		"modifier": "sam_test",   //修改人
		"time": "2019-05-30 11:08", //修改时间
		"fieldValue": "22" //修改值
	}, {
		"modifier": "sam_test",
		"time": "2019-05-30 11:15",
		"fieldValue": "22222"
	}]
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 控件修改信息             |