# 计算脚本输出属性

背景：

项目实施中，因为某种特殊情况，需要用到计算脚本输出一段HTML返回页面显示，但是，输出的HTML中，带有input属性的值是无法在脚本中通过getParameter获取，所以，在次规定输出HTML格式，从而达到可以获取的效果。

#### 1.计算脚本输出格式

```html
<input type="text" storage="exparams" name="fieldName" value="fieldValue"/>
```

| 参数    | 说明                                |
| ------- | ----------------------------------- |
| storage | 类型：exparams（目前只支持参数的方式） |
| name    | 字段名                              |

#### 2.前端处理

构建document包体时，查找一下带有storage="exparams"属性的input属性，然后放在supplyParams(补充参数)里面，格式

```json
{
  "items": {
    "姓名":"小明"
  },
  "applicationId": "sOZu9kthmxyP8qQfq0e",
  "id": "__ugN7NWk9G9yQMHHreR8",
  "templateForm": "",
  "formId": "9c0aqDXwpcfHP2G5wCv",
  "sign": "",
  "parentId": "",
  "isRelate": "false",
  "subDocuments": [],
  "versions": "0",
  "exparams":{
      "fieldName":"fieldValue"
  }
}
```

#### 3.后端处理

在解析前端传输的包体数据时，获取supplyParams里面的值，将其设置到ParamsTable中初始化runner，如此，脚本中便可通过getParameter获取

#### 4.栗子

计算脚本输出HTML片段

```html
<table style="border: 2px solid rgb(180, 204, 238);">
    <tbody>
        <tr>
    		<td colspan="2">我是个表格</td>
    	</tr>
		<tr>
            <td>说明：</td>
        	<td><input type="text" storage="exparams" name="comment" value="哈哈哈"></td>
    	</tr>
	</tbody>
</table>
```

提交执行前按钮获取

```js
(function(){                                             
  var comment = getParameter("comment");                                       
  println("comment------>"+comment);                                        
  return comment;                                                                    
})()
```

