# myApps工程结构


![1553661117663](.\images\1544864835620.png)

## obpm-common

通用工程，所有工程的公共依赖，包含：最基础的model。基础的工具类。

## obpm-uc

用户中心工程，处理用户登录以及登录后的session初始化，基于spring security实现，session初始化后，通过spring session将session信息序列化到数据库（JDBC或redis）中，以实现不同jvm之间的session共享。

## obpm-core
核心工程，从旧的obpm工程中迁移过来，包含myApps的主要功能模块，action/controler、process/service、dao等，道理上，不应该包含action/controler层以及web表示层（jsp、html等）的内容，但考虑到目前仍处于清理过程中，暂时如此。

## obpm-authtime
授权时工程，实现域管理员对于部门、用户、软件、权限等的管理。

## obpm-runtime
运行时的工程，包含主页、widget、表单、视图、流程、报表等myApps的主要核心构件（要将主要功能模块从obpm-core中逐渐迁移到本工程中）。基于spring session实现与obpm-uc模块的session共享（作为企业级应用，保留session的存在，纯粹的无状态意义不大）

## obpm-runtime-alone

继承自（依赖）obpm-runtime，作为运行时态可独立运行的打包版本，运行时不需要依赖redis和发现服务（redis、eurka），直接用springboot命令行启动即可，启动前需要有mysql或其它关系型数据库服务。

## obpm-runtime-consul

继承自（依赖）obpm-runtime，作为运行时态与发现服务一起运行的打包版本，运行时必须依赖redis和发现服务（consul），直接用springboot命令行启动，启动之前必须先启动consul及redis（作为session共享及缓存服务）以及mysql或其它关系型数据库服务。


## obpm-zuul

作为api网管，继承自（依赖）zuul，具备负载均衡能力，启动之前必须先启动consul。

## obpm-designer
设计器工程，实现软件开发者通过表单设计器、流程设计器、视图（查询）设计器设计出一个自己的软件，设计出来的软件（应用）通过xml的格式存放在文件系统中。

**注意：obpm-designer和obpm-runtime-alone、obpm-runtime-consul、obpm-zuul可以单独运行，其它的项目不能单独运行。**



# 开发环境设置

## IDE选择
myApps4.2基于Spring boot架构，天翎公司建议的IDE工具是Spring Tools Suit4（安装Subslipse插件实现对SVN的支持），前端开发工具建议用Visual Studio Code。虽然InteliJ IDEA也是一个不错的IDE工具，考虑到尊重版权的原因不在公司范围内推荐。

## JDK选择
为普遍兼容性考虑，开发时使用的JDK版本为Java SDK1.7

## 数据库
myApps4.2需要兼容的数据库类型包括：mysql、mssql、db2、oracle、postgresql，在开发时建议本机安装mysql5.7版本，其它数据库开发测试用公司统一配置的虚拟机。

## 版本控制器
虽然Git也是非常流行的版本控制器，但作为中心管理更为简洁的考虑，天翎采用svn作为统一的版本控制器。
SVN地址：https://www.teemlink.com:8443/svn/platform/trunk2018
账号需要按公司流程申请，发邮件到vicky@teemlink.com并抄送给自己的主管，版本控制器的账号名密码需要妥善保管，不得外借以便在提交代码后能够反向追溯责任。



## 开发协作平台（BUG管理）
禅道：
http://office.teemlink.com:9091/zentao/

# 工程初始化

## 库的初始化

## Java工程初始化
通过svn签出（check out）工程（们）到本地，通过STS的File->Import->Maven->Existing Maven Project引入到workspace中。出现错误后，根据STS的Problems窗口提示，修正之（通常是maven 需要Update、DK版本不匹配、Project Facade等）

## 启动
修正所有错误后，找到工程（们）的入口文件，通常为XxxApp.java，右键点击文件->Run As->Spring Boot App
先启动obpm-uc、然后再启动obpm-runtime。启动前需要确保数据库（mysql）已经被正常启动，并且工程所需要的端口没有被其它程序所占用。

### 设计器（obpm-designer）

启动类：/obpm-designer/src/main/java/cn/myapps/run/DesignerApp.java

默认端口：8082

访问地址：http://localhost:8082/designer

### 运行器-单机（obpm-runtime-alone）

启动类：/obpm-runtime-alone/src/main/java/cn/myapps/run/RunTimeAppAlone.java

默认端口：8080

访问地址：http://localhost:8080/obpm

### 运行器-集群（obpm-obpm-consul）

启动类：/obpm-runtime-consul/src/main/java/cn/myapps/run/RuntimeWithConsulApp.java

默认端口：8081

访问地址：http://localhost:8081/obpm

# 时态

myApps分为三个主要时态，如图：

![tense](./images/tense.png)



**设计时：**操作并存储表单、流程、视图、报表等

**授权时：**操作并存储用户、部门、权限等

**运行时：**实际用户使用系统并存储业务数据，如通过myApps定制出一个客户关系管理系统（CRM），销售文员通过该CRM录入客户信息。

## 平台层次结构

![](.\images\layer.png)

## 设计时基础类结构

![1552380305005](./images/1552380305005.png)

## 授权时基础类结构

![1552380346046](./images/1552380346046.png)

## 运行时基础类结构

![1552380369120](./images/1552380369120.png)

## 运行时及设计时继承结构

![1552380389304](./images/1552380389304.png)

# 开发原则

1. 不同时态的service不能互相调用
2. 相同时态的dao可以互相调用
3. vo对象中，不能出现service或dao
4. 考虑和现有版本的合并难度
5. 采用剥离的方式，web部分因为互相关联不多，可以先做，Action和jsp先分离出来。

# 生产环境部署

![1552979119550](.\images\5C1552979119550.png)

**说明：**consul和redis的部署，可以用工程主目录下env里面的consul和redis版本，并参见相关安装文档。



# 已知问题及修正策略

1. spring boot 自定义拦截器问题，MyappsMvcConfig过时替换
2. @config类所在路径问题。通过启动入口类中basepackage指定
3. RunTimeServiceConfig 中Env方法命名问题
4. @service id问题，在之前类命名时，有不同包但同名，需要处理
5. maven包冲突解决
6. jstl自定义标签问题：tld位置、uri设置
7. 静态资源问题，spring boot2.x自定义拦截器，会影响到静态资源
8. 自定义拦截器重构
9. 编译问题，*.xml没有打包（确定是java工程的过滤器问题）
10. /portal/share/common/msgbox/msg.jsp问题，各个时态不能混用
11. 在用户管理中，KM的role、Resource获取应该走远程接口，不应该是本地直接调用？（直接用配置文件写死也是好办法，可以做成插件方式）
12. 如果designtime是独立的，域管理和开发者要分开
13. 类型不一致问题，造型错，很奇怪（devtools引发的血案），不打算解决，不用devtools就是了
14. listByDepartment的url映射为啥丢失.action之前的版本能正确吗？
15. 新的加密机制问题，如果不是license.zip，那么如何做？是否改为网络云服务id认证？（可以是classloader，考虑把dao部分改到license里面）
16. maven的父子工程关系
17. testcase滥用，应该知足测试状态下使用
18. dwr中映射文件的清理，很多没有用到的class垃圾
19. 是否继续使用proxool？不用连接池好像没有毛病，为hibernate下一步升级打下基础。
20. SpringApplicationContextUtil初始化次序问题，避免使用静态变量
21. 对于静态资源的拦截问题
22. Springboot 对于./xxx静态路径的拦截，要求路径书写规范
23. 匿名用户登录用到AnonymousAuthenticationToken、AnonymousAuthenticationProvider、AnonymousAuthenticationFilter
24. 系统数据源的设定，是用什么？目前还是用hibernate.properties配置
25. 将hibernate的dao改为jpa，简化目前的开发配置
26. 将运行时和授权时的dwr移除
27. KmAppConfig.java是垃圾，要移除
28. 用WebSecurityConfig.java绕过spring security的安全校验，用回原来的security filter，之后结合uc部分进行改造（uc是不是应该改个名称？）
29. SPRING BOOT上传要重构
30. userProcess.login(loginno)方法要传入domainname才能保证多租户条件下功能正常
31. webuser改造还是要进行，不改不行（重要！！！）
32. session部分，有两个思路，一是放在onlineuser里面，二是改造spring session的repository
33. 用listener模式改造流程引擎
34. 用redis作为缓存
35. HttpSessionBindingListener不生效，spring boot2.1.0是OK，2.0.5不OK，妈的！坑了一下午
36. DesignTimeIndexCacheManager和RunTimeIndexCacheManager，在初始化的时候做了两次，要合并
37. jsaperreport引发spring boot2.1的jsp编译问题
38. 1.5.0-alpha.16引发的问题，为啥要jruby
39. 文件upload作为一个单独的服务处理。如：obpm-filemanager或obpm-filecenter
40. 更换durid版本，兼容新版mysql驱动
41. 将obpm-uc分解为obpm-security和obpm-gateway，更合适
42. 后台的上传和前台的上传应该不一样，后台上传到workspace，前台上传到obpm-filemanager
43. WebUser和AdminUser和DevUser分开
44. getServletContext可能挖的坑，在spring boot下已经是将web资源打包到jar内，无法更改， setApplicationRealPath
45. mobile包清理
46. report包清理
47. XXXXRunTimeService和XXXXRunTimeServiceImpl要被合并。。。
48. AbstractRunTimeProcessBean清理掉
49. 流程引擎要重构，现在的流程引擎入口混乱，documentprocess，statemachine都可以操作，统一到statemachine


json处理机制要统一