package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 权限表
 */
@Entity
@Table(name = "base_role_menu")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class RoleMenu extends BaseBean {

	private static final long serialVersionUID = 1L;

	private Long role_id;

	private Long menu_id;


	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final RoleMenu other = (RoleMenu) obj;
		if( this.getMenu_id().equals(other.getMenu_id())) {
			return false;
		}
		return true;
	}

}
