package com.bcxin.risk.policy.dto.data;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class PolicyDto {

	private String oid;
	private String userId;

	private String externalReference;//保单号

	private String blbOrderId;//百联保保险订单id
	private String orderNo;//订单号
	private String applicantName;//投保人
	private String productName;//产品名称
	private String insuranceName;//保险公司
	private String insuranceObject;//保险对象

	private String inceptionDate;

	private String plannedEndDate;

	private String signedDate;

	private String createOn;

	private String policyStatus; 
	
	private String policyStatusCN;

	private String amount;
	private String policyURL; //电子保单地址
	private String invoiceURL; //电子发票地址

	private Page page;


	public PolicyDto(){}
	
	public PolicyDto(Map<String,Object> map){
		this.createOn = safeTransfor(map.get("createOn"));
		this.inceptionDate = safeTransfor(map.get("inceptionDate"));
		this.plannedEndDate = safeTransfor(map.get("plannedEndDate"));
		this.signedDate = safeTransfor(map.get("signedDate"));
		this.blbOrderId = safeTransfor(map.get("blbOrderId"));
		this.orderNo = safeTransfor(map.get("orderNo"));
		this.externalReference = safeTransfor(map.get("externalReference"));
		this.applicantName = safeTransfor(map.get("applicantName"));
		this.productName = safeTransfor(map.get("productName"));
		this.insuranceName = safeTransfor(map.get("insuranceName"));
		this.insuranceObject = safeTransfor(map.get("insuranceObject"));
		this.policyURL = safeTransfor(map.get("policyURL"));
		this.invoiceURL = safeTransfor(map.get("invoiceURL"));
		this.oid = safeTransfor(map.get("oid"));
		this.policyStatus = safeTransfor(map.get("policyStatus"));
		this.amount = safeTransfor(map.get("amount"));
		if ( StringUtil.isNotEmpty(this.policyStatus) ) {
			this.setPolicyStatusCN("6".equals(this.policyStatus)?"保障中":"12".equals(this.policyStatus)?"已失效":"");
		}
	}
	
	/**
	 * <b> Function 将Object安全转换为String </b>
	 * @author ZXF
	 * @create 2024/01/23 0023 11:20
	 * @version
	 * @注意事项 </b>
	 */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
}
