package com.bcxin.risk.policy.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.*;

/**
 * <b> 保险订单信息 </b>
 * @author ZXF
 * @create 2024/01/23 0023 10:46
 * @version
 * @注意事项 </b>
 */
@Entity
@Table(name = "RISK_InsurancePolicy")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class InsurancePolicy extends BaseBean {
	
	private static final long serialVersionUID = 1L;


	private String userId;

	private String externalReference;//保单号

	private String blbOrderId;//百联保保险订单id
	private String orderNo;//订单号
	private String applicantName;//投保人
	private String productName;//产品名称
	private String insuranceName;//保险公司
	private String insuranceObject;//保险对象

	@Temporal(TemporalType.TIMESTAMP)
	private Date signedDate;//投保日期
	@Temporal(TemporalType.DATE)
	private Date inceptionDate;//生效日期
	@Temporal(TemporalType.DATE)
	private Date plannedEndDate;//失效日期

	private BigDecimal premium = BigDecimal.ZERO;//保费

	private String policyStatus;//保单状态

	private String policyURL; //电子保单地址
	private String invoiceURL; //电子发票地址
	private int isSync; //是否完成同步 0未完成 1完成；这里同步指推送商城成功完成订单与用户的绑定，如果有推送但绑定失败这里也一样为0

}
