package com.bcxin.risk.org.domain;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 承办单位
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ContractorOrg")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ContractorOrg extends Org {

	private static final long serialVersionUID = 1L;

	/**
	 * 政府单位标志
	 */
	private String govOrgFlag;

	/**
	 * 组织机构代码
	 */
	private String organizationCode;

	/**
	 * 组织机构代码扫描件
	 */
	private String organizationCode_license;

	/**
	 * 描述
	 */
	private String description;

	/**
	 * 服务机构类型,1.风评，2.安保
	 */
	private String serviceOrgType;

}
