package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 文件同步标示（用于记录审批系统同步过来的文件记录，不记录申报系统生成的文件记录）
 */
@Entity
@Table(name = "log_SPFileSyncLog")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class SPFileSyncLog extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 同步的文件名称
	 */
	private String fileName;

	/**
	 * 同步的文件目录
	 */
	private String dir;

	/**
	 * 读取状态，默认为未读
	 */
	private String markRead;

	/**
	 * 读取时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date readTime;

}
