package com.bcxin.risk.common.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 基础数据（省市县）
 * @author luopeng
 *
 */
@Entity
@Table(name = "base_region")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Region extends BaseBean {

	private static final long	serialVersionUID	= 1L;

	/**
	 * 省和直辖市
	 */
	private String province;

	/**
	 * 市/县
	 */
	private String city;

	/**
	 * 区
	 */
	private String area;

	/**
	 * 父级
	 */
	private String parent_id;

	/**
	 * 区域级别
	 */
	private String level;

	/**
	 * 别名（每个省的别名）
	 */
    private String alias;

	/**
	 * 展示排序顺序
	 */
    private int seq;

}
