package com.bcxin.risk.common.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * <b> 各个省协同业务员配置表 </b>
 * @author ZXF
 * @create 2024/03/18 0018 15:12
 * @version
 * @注意事项 </b>
 */
@Entity
@Table(name = "base_business_ownership")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class BusinessOwnership extends BaseBean {

	private static final long	serialVersionUID	= 1L;


	/**
	 * 省名称
	 */
	private String province;

	/**
	 * 业务人员
	 */
	private String businessName;

	/**
	 * 业务手机号
	 */
	private String businessMobile;

	/**
	 * 是否启用
	 */
	private int active;

}
