package com.bcxin.risk.base.domain;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;


@Entity
@Table(name = "config_function")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ConfigFunction extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 限制活动举办时间与当前时间最小天数
	 */
	private String activityLimitMinDay;

	/**
	 * 等级评定
	 */
	private String activityGradeRank;

	/**
	 * 风评展示方式
	 * 1：展示评估机构，支持跳转
	 * 2：展示评估机构，不支持跳转
	 * 3：不展示评估机构
	 */
	private String assessmentShow;

	/**
	 * 适用省份
	 */
	private String province;

}
