package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * <b> 活动其它附属订单表 </b>
 * @author ZXF
 * @create 2024/04/11 0011 15:29
 * @version
 * @注意事项 </b>
 */
@Entity
@Table(name = "risk_activity_other_order")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityOtherOrder extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 活动名称
     */
	private String activityName;

    /**
     * 活动编号(商城订单编号)
     */
    private String activityNo;
    /**
     * 订单编号(商城订单编号)
     */
    private String orderNo;
    private String userId;
    /**
     * 商城商品ID
     */
    private String skuId;
    /**
     * 商城商品名称
     */
    private String productName;
    /**
     * 商城商品编码
     */
    private String productCode;
    private String province;
    private String city;
    private String area;
    private String activityStartDate;
    private String activityEndDate;
    private String amount;
    private String fileUrl;//订单可能会生成文件
    private String serverOrg;
    /* 状态：9废弃；0未完成；1已完成 */
    private int status;
}
