package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.user.domain.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * 活动报价表
 * @author 罗鹏
 */
@Entity
@Table(name = "risk_activity_cost")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityCost extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 活动名称
     */
	private String activityName;

    /**
     * 活动编号(商城订单编号)
     */
    private String activityNo;
    private String userId;
    /**
     * 商城商品ID
     */
    private String skuId;
    private String province;
    private String city;
    private String area;
    private String activityType;
    private String addressType;
    private String exhibitionType;
    private String activityNum;
    private String days;
    private String activityStartDate;
    private String activityEndDate;
    private String amount;
    private String serverOrg;
    /* 加急 */
    private String reportUrgent;
    /* 纸质报告 */
    private String paperReport;
    /* 专家份数 */
    private int expertCopies;
    /* 踏勘份数 */
    private int reconnaissanceCopies;
}
