package com.bcxin.risk.activity;

import com.bcxin.risk.base.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

/**
 * <b> 活动协同附件上传 </b>
 * @author ZXF
 * @create 2024/03/13 0013 16:11
 * @version
 * @注意事项 </b>
 */
@Entity
@Table(name = "RISK_Activity_Cooperate_File")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityCooperateFile extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 活动
     */
    @ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "activity_id")
    private Activity activity;


    /**
     * 意见
     */
    private String comments;

    /**
     * 协同文件
     */
    private String coopFile;

    /**
     * 是否有效
     */
    private String opStatus;


}
