package com.bcxin.risk.report.material.dto;

import lombok.Data;

import java.util.Map;

/**
 * 供数据转换使用
 */
@Data
public class MaterialDTO {

    private String code;

    private String value;



    public MaterialDTO(Map<String,Object> map){
        this.code = safeTransfor(map.get("code"));
        this.value = safeTransfor(map.get("value"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
