package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import javax.persistence.*;


/**
 * 合同认证
 * @author Ethan
 */
@Entity
@Table(name = "RISK_Contract")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Contract extends BaseBean {

	private static final long serialVersionUID = -1102447452173844640L;

	private String uploadKey;

	@Type(type="text")
	private String uploadPath;
	
	private String inputKey;
	
	private String fileName;
	
	private String active;
	
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "user_id")
	private User user;
	
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;

}
