package com.bcxin.risk.report.dto.data;


import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class ReportDTO {

	private String reportId;

	private String taskDate;

	private String assignDate;

	private String orderNo;

	private String activityName;

	private String activityType;

	private String reportSubStatus;

	private String reportStatus;

	private String pgbg;

	private Page page;


	public ReportDTO(Map<String,Object> map){
		this.reportId = safeTransfor(map.get("reportId"));
		this.taskDate = safeTransfor(map.get("taskDate"));
		this.assignDate = safeTransfor(map.get("assignDate"));
		this.orderNo = safeTransfor(map.get("orderNo"));
		this.activityName = safeTransfor(map.get("activityName"));
		this.activityType = safeTransfor(map.get("activityType"));
		this.reportSubStatus = safeTransfor(map.get("reportSubStatus"));
		this.reportStatus = safeTransfor(map.get("reportStatus"));
		this.pgbg = safeTransfor(map.get("pgbg"));
	}


	/**
	 *
	 * <b>Function 将Object安全转换为String</b>
	 *
	 * @param obj
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月22日 下午5:17:02
	 * @注意事项 </b>
	 * <b>
	 */
	private static String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
}
