/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.utils;

import com.bcxin.risk.hibernateplus.entity.EntityFieldInfo;
import com.bcxin.risk.hibernateplus.entity.EntityInfo;
import com.bcxin.risk.hibernateplus.utils.EntityInfoUtils;
import com.bcxin.risk.hibernateplus.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;

public class ReflectionKit {
    private static final Logger logger = Logger.getLogger(ReflectionKit.class);

    public static String getMethodCapitalize(String str) {
        return StringUtils.concatCapitalize("get", str);
    }

    public static Object getMethodValue(Class<?> cls, Object entity, String str) {
        Object obj = null;
        try {
            Method method = cls.getMethod(ReflectionKit.getMethodCapitalize(str), new Class[0]);
            obj = method.invoke(entity, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.warn((Object)(String.format("Warn: No such method. in %s.  Cause:", cls.getSimpleName()) + e));
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)(String.format("Warn: Cannot execute a private method. in %s.  Cause:", cls.getSimpleName()) + e));
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)("Warn: Unexpected exception on getMethodValue.  Cause:" + e));
        }
        return obj;
    }

    public static Object getMethodValue(Object entity, String str) {
        if (null == entity) {
            return null;
        }
        return ReflectionKit.getMethodValue(entity.getClass(), entity, str);
    }

    public static boolean checkFieldValueNotNull(Object bean) {
        if (null == bean) {
            return false;
        }
        Class<?> cls = bean.getClass();
        EntityInfo entityInfo = EntityInfoUtils.getEntityInfo(cls);
        boolean result = false;
        for (EntityFieldInfo fieldInfo : entityInfo.getFieldInfos()) {
            String fieldName = fieldInfo.getProperty();
            Object val = ReflectionKit.getMethodValue(cls, bean, fieldName);
            if (!StringUtils.checkValNotNull(val)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn((Object)String.format("Warn: %s's superclass not ParameterizedType", clazz.getSimpleName()));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn((Object)String.format("Warn: Index: %s, Size of %s's Parameterized Type: %s .", index, clazz.getSimpleName(), params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn((Object)String.format("Warn: %s not set the actual class on superclass generic parameter", clazz.getSimpleName()));
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Map<String, Method> getReturnMethods(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (Method method : methods) {
            Type genericReturnType = method.getGenericReturnType();
            if (Void.TYPE.equals(genericReturnType)) continue;
            methodMap.put(method.getName(), method);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return methodMap;
        }
        methodMap.putAll(ReflectionKit.getReturnMethods(superClass));
        return methodMap;
    }

    public static <T extends Annotation> boolean hasAnnotation(Method method, Class<T> annotationClass) {
        return method.getAnnotation(annotationClass) != null;
    }
}

