/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.utils;

import com.bcxin.risk.hibernateplus.entity.EntityFieldInfo;
import com.bcxin.risk.hibernateplus.entity.EntityInfo;
import com.bcxin.risk.hibernateplus.enums.Setting;
import com.bcxin.risk.hibernateplus.exceptions.HibernatePlusException;
import com.bcxin.risk.hibernateplus.utils.CollectionUtils;
import com.bcxin.risk.hibernateplus.utils.ReflectionKit;
import com.bcxin.risk.hibernateplus.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.SessionFactory;
import org.jboss.logging.Logger;

public class EntityInfoUtils {
    private static final Logger logger = Logger.getLogger(EntityInfoUtils.class);
    private static final String DEFAULT_ID_NAME = "id";
    private static final Map<String, EntityInfo> modelCache = new ConcurrentHashMap<String, EntityInfo>();

    public static EntityInfo getEntityInfo(Class<?> clazz) {
        return modelCache.get(clazz.getName());
    }

    public static void initSession(SessionFactory sessionFactory, Setting setting) {
        block4: for (Map.Entry<String, EntityInfo> entry : modelCache.entrySet()) {
            EntityInfo entityInfo = entry.getValue();
            switch (setting) {
                case MASTER: {
                    if (entityInfo.getMaster() != null) continue block4;
                    entityInfo.setMaster(sessionFactory);
                    continue block4;
                }
                case SLAVE: {
                    Set<SessionFactory> slaves = entityInfo.getSlaves();
                    if (CollectionUtils.isEmpty(slaves)) {
                        slaves = new HashSet<SessionFactory>();
                    }
                    slaves.add(sessionFactory);
                    entityInfo.setSlaves(slaves);
                    continue block4;
                }
            }
            throw new HibernatePlusException("Error: Master-slave Setting error !");
        }
    }

    public static synchronized EntityInfo initEntityInfo(Class<?> clazz) {
        EntityInfo entityInfo = modelCache.get(clazz.getName());
        if (entityInfo != null) {
            return entityInfo;
        }
        entityInfo = new EntityInfo();
        Table table = clazz.getAnnotation(Table.class);
        String tableName = null;
        if (table != null && StringUtils.isNotBlank(table.name())) {
            tableName = table.name();
        }
        if (tableName == null) {
            logger.warn((Object)"Warn: Entity @Table Not Found!");
        }
        entityInfo.setTableName(tableName);
        Set<EntityFieldInfo> fieldInfos = EntityInfoUtils.entityFieldInfos(clazz, entityInfo);
        entityInfo.setFieldInfos(fieldInfos);
        if (StringUtils.isBlank(entityInfo.getKeyProperty())) {
            Iterator<EntityFieldInfo> iterator = fieldInfos.iterator();
            while (iterator.hasNext()) {
                EntityFieldInfo fieldInfo = iterator.next();
                String column = fieldInfo.getColumn();
                if (!DEFAULT_ID_NAME.equals(column)) continue;
                entityInfo.setKeyColumn(DEFAULT_ID_NAME);
                entityInfo.setKeyProperty(fieldInfo.getProperty());
                iterator.remove();
                break;
            }
            if (StringUtils.isBlank(entityInfo.getKeyProperty())) {
                logger.warn((Object)String.format("Warn: Don't have a primary key %s", clazz.getSimpleName()));
            }
        }
        modelCache.put(clazz.getName(), entityInfo);
        return entityInfo;
    }

    private static Set<EntityFieldInfo> entityFieldInfos(Class<?> clazz, EntityInfo entityInfo) {
        LinkedHashSet<EntityFieldInfo> fieldInfos = new LinkedHashSet<EntityFieldInfo>();
        Map<String, Method> methodMap = ReflectionKit.getReturnMethods(clazz);
        Set<Field> fields = EntityInfoUtils.getClassFields(clazz);
        for (Field field : fields) {
            Class<?> type = field.getType();
            String fieldName = field.getName();
            String methodName = ReflectionKit.getMethodCapitalize(fieldName);
            Method method = methodMap.get(methodName);
            if (method == null && Boolean.class.isAssignableFrom(type)) {
                method = methodMap.get(StringUtils.concatCapitalize("is", fieldName));
            }
            if (method != null) {
                String name;
                Column column;
                if (ReflectionKit.hasAnnotation(method, Id.class)) {
                    if (ReflectionKit.hasAnnotation(method, Column.class)) {
                        column = method.getAnnotation(Column.class);
                        name = column.name();
                        entityInfo.setKeyColumn(StringUtils.isBlank(name) ? fieldName : name);
                    } else {
                        entityInfo.setKeyColumn(fieldName);
                    }
                    entityInfo.setKeyProperty(fieldName);
                    continue;
                }
                if (!ReflectionKit.hasAnnotation(method, Column.class)) continue;
                column = method.getAnnotation(Column.class);
                name = column.name();
                EntityFieldInfo entityFieldInfo = new EntityFieldInfo();
                entityFieldInfo.setProperty(fieldName);
                entityFieldInfo.setColumn(StringUtils.isBlank(name) ? fieldName : name);
                fieldInfos.add(entityFieldInfo);
                continue;
            }
            logger.warn((Object)String.format("Warn: Entity Field %s does has get Method!", fieldName));
        }
        return fieldInfos;
    }

    private static Set<Field> getClassFields(Class<?> clazz) {
        Field[] fields;
        LinkedHashSet<Field> result = new LinkedHashSet<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Transient annotation;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || (annotation = field.getAnnotation(Transient.class)) != null) continue;
            result.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return result;
        }
        result.addAll(EntityInfoUtils.getClassFields(superClass));
        return result;
    }
}

