/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.entity;

import com.bcxin.risk.hibernateplus.entity.EntityFieldInfo;
import com.bcxin.risk.hibernateplus.utils.CollectionUtils;
import com.bcxin.risk.hibernateplus.utils.StringUtils;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.SessionFactory;

public class EntityInfo {
    private String tableName;
    private String keyProperty;
    private String keyColumn;
    private Set<EntityFieldInfo> fieldInfos;
    private String select;
    private SessionFactory master;
    private Set<SessionFactory> slaves;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public Set<EntityFieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public void setFieldInfos(Set<EntityFieldInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public String getSelect() {
        if (StringUtils.isBlank(this.select)) {
            StringBuilder selectBuild = new StringBuilder();
            selectBuild.append(this.getKeyColumn());
            selectBuild.append(" AS ");
            selectBuild.append(this.getKeyProperty());
            selectBuild.append(",");
            Set<EntityFieldInfo> fieldInfos = this.getFieldInfos();
            if (CollectionUtils.isNotEmpty(fieldInfos)) {
                Iterator<EntityFieldInfo> iterator = fieldInfos.iterator();
                int _size = fieldInfos.size();
                int i = 1;
                while (iterator.hasNext()) {
                    EntityFieldInfo fieldInfo = iterator.next();
                    String column = fieldInfo.getColumn();
                    String property = fieldInfo.getProperty();
                    if (i == _size) {
                        selectBuild.append(column);
                        selectBuild.append(" AS ");
                        selectBuild.append(property);
                    } else {
                        selectBuild.append(column);
                        selectBuild.append(" AS ");
                        selectBuild.append(property);
                        selectBuild.append(",");
                    }
                    ++i;
                }
            }
            this.setSelect(selectBuild.toString());
        }
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public SessionFactory getMaster() {
        return this.master;
    }

    public void setMaster(SessionFactory master) {
        this.master = master;
    }

    public Set<SessionFactory> getSlaves() {
        return this.slaves;
    }

    public void setSlaves(Set<SessionFactory> slaves) {
        this.slaves = slaves;
    }
}

