/**
 * The MIT License (MIT)
 * <p>
 * Copyright (c) 2016 Caratacus
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.bcxin.risk.hibernateplus.dao;

import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * IDao接口
 * </p>
 *
 * @author Caratacus
 * @date 2016-11-23
 */
public interface IDao<P> {

    void evictObj(Object obj);

    void mergeObj(Object obj);

    boolean insertBatch(List<P> list, int size);

    Criteria createCriteria(Class clazz);

    <T>T selectById(Long oid);

    <T>T selectOne(Criterion criterion);

    <T>T selectOne(List<Criterion> criterionList);

    void save(Object obj);

    void saveOrUpdate(Object obj);

    void update(Object obj);

    void deleteObj(Object obj);

    int delete(Serializable id);

    int delete(Wrapper wrapper);

    boolean updateBatch(List<P> list, int size);

    <T>List selectList();

    <T>List selectList(Order order);

    <T>List selectList(Criterion criterion);

    <T>List selectList(Criterion criterion, Order order);

    <T>List selectPage(Criterion criterion, Page page);

    <T>List selectList(List<Criterion> criterionList);

    <T>List selectList(List<Criterion> criterionList,Order order);

    int selectCount();

    <T>List selectPage(List<Criterion> criterionList, Page page);

    <T>List selectPage(List<Criterion> criterionList, Page page, Order order);

    <P> List<P> selectList(Wrapper wrapper);

    List<Map<String, Object>> selectMaps(Wrapper wrapper);

    P selectOne(Wrapper wrapper);

    Page selectPage(Wrapper wrapper, Page page);

    List<Map<String, Object>> queryMaps(String sql, Wrapper wrapper);

    int querySqlCounts(String sql, Wrapper wrapper);

    Map<String, Object> queryMap(String sql, Wrapper wrapper);


}