package com.risk.test;

import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.common.util.cipher.MD5Util;
import com.bcxin.risk.constant.Const;
import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.*;
import com.google.common.io.Files;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;


public class Test {

    private static final Pattern pTableTag = Pattern.compile("<table.*>.+</table>");
    private static final Pattern pTrTag = Pattern.compile("<tr>");
    private static final Pattern pTdTag = Pattern.compile("<td>");

    private static final Logger logger = LoggerFactory.getLogger(Test.class);

    @Autowired
    private BCryptPasswordEncoder bcryptEncoder;

    public List<String[][]> getTable(String tableStr) {
        StringBuilder builder = new StringBuilder("<html><head><title></title></head><body>").append(tableStr).append("</body><html>");
        org.jsoup.nodes.Document doc = Jsoup.parse(builder.toString());
        Elements tables = doc.select("table");
        List<String[][]> tableList = Lists.newArrayList();
        for (Element table : tables) {
            if (table == null) {
                continue;
            }

            int trSize = 0;
            int tdSize = 0;
            Elements trs = table.select("tr");
            trSize = trs.size();
            for (Element tr : trs) {
                if (tr != null) {
                    Elements childrens = tr.children();
                    tdSize = childrens.size();
                    break;
                }
            }

            String[][] strs = new String[trSize][tdSize];
            for (int i=0;i<trs.size();i++) {
                Element tr = trs.get(i);
                if ( tr != null) {
                    Elements childrens = tr.children();
                    for (int y=0;y<childrens.size();y++) {
                        if (y < tdSize) {
                            strs[i][y] = childrens.get(y).text();
                        }
                    }
                }
            }
            tableList.add(strs);
        }

        return tableList;
    }

    public static void main(String[] args) throws Exception{

        logger.debug("test log");

        //IntStream.iterate(1, i -> i < 100, i -> i + 1).forEach(System.out::println);
//
//		//字符串处理
//		String a = "我爱北京天安门";
//        String b = "我爱各种门";
//        String ourCommonPrefix = Strings.commonPrefix(a,b);
//        String ourCommonSuffix = Strings.commonSuffix(a,b);
//        System.out.println("相同的部分前缀是：" + ourCommonPrefix);
//        System.out.println("相同的部分后缀是：" + ourCommonSuffix);
//
//        //自动补全
//        int minLength = 10;
//        String padEndResult = Strings.padEnd("123", minLength, '0'); //padStart
//        System.out.println("自动补全后：" + padEndResult);
//
//        //复制字符串
//        System.out.println(Strings.repeat("小林", 5));
//
//        //合并字符串
//        List<String> strlist = Lists.newArrayList("a",null,"c");
//        String newstr = Joiner.on("#").skipNulls().join(strlist); //.useForNull("")
//        System.out.println("合并字符串后："+newstr);
//
//        //CharMatcher
//		System.out.println("找出字符串中的数字："+CharMatcher.DIGIT.retainFrom("1998-12-12年，香港回归")); //removeFrom
//		System.out.println("找出字符串中符合条件的："+CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).removeFrom("AaBcZx2"));
//		System.out.println();
//		System.out.println(CharMatcher.JAVA_DIGIT.retainFrom("12.0"));
//
//
//        //Ints
//		int[] array = {10,2,3,5,9};
//		Ints.indexOf(array, 4);
//		Ints.contains(array, 4);
//		Ints.max(array);
//		Ints.min(array);
//
//
//		HashSet<Integer> setA = Sets.newHashSet(1, 2, 3, 4, 5);
//		HashSet<Integer> setB = Sets.newHashSet(4, 5, 6, 7, 8);
//
//		SetView<Integer> union = Sets.union(setA, setB);
//		SetView<Integer> difference = Sets.difference(setA, setB);
//		SetView<Integer> intersection = Sets.intersection(setA, setB);
//		System.out.println("union:"+union); //合集
//		System.out.println("difference:"+difference); //差集
//		System.out.println("intersection:"+intersection);//并集
//
////		for (Integer i : union) {
////
////		}
//
////		collection();
//
//
//
		BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        System.out.println("---------------");
		System.out.println(encoder.encode("mxrmzfbgs"));
//		System.out.println("---------------");

//		System.out.println(DigestUtils.md5Hex("sp@2017"));;
//		System.out.println(DigestUtils.md5Hex("pss@2017"));;

		//genFile();

        System.out.println("秘钥是："+MD5Util.string2MD5(Const.ENVI + DateUtil.today()));

    }

    private static void collection(){
        //不可变集合
        ImmutableList<String> immutableList = ImmutableList.of("a", "b", "c", "d");
        //不可变map
        ImmutableMap<String,String> immutableMap = ImmutableMap.of("key1", "value1", "key2", "value2");

        Student s1 = new Student();
        s1.setClasses("class1");
        s1.setName("张三");

        Student s2 = new Student();
        s2.setClasses("class2");
        s2.setName("李二");

        Student s3 = new Student();
        s3.setClasses("class1");
        s3.setName("张四");

        List<Student> studentList = Lists.newArrayList();
        studentList.add(s1);
        studentList.add(s2);
        studentList.add(s3);

        /* 旧的写法 */
        Map<String,List<String>> listMap = Maps.newHashMap();
        for (Student student : studentList) {
            if (CollectionUtil.isEmpty(listMap.get(student.getClasses()))) {
                List<String> nameList = Lists.newArrayList();
                nameList.add(student.getName());
                listMap.put(student.getClasses(),nameList);
            } else {
                listMap.get(student.getClasses()).add(student.getName());
            }
        }

        Multimap<String, String> multimap = ArrayListMultimap.create();
        for (Student student : studentList) {
            multimap.put(student.getClasses(),student.getName());
        }
        /* 得到class1的集合 */
        Collection<String> list = multimap.get("class1");

        multimap.put("date", "2017-01-01");
        multimap.put("date", "2017-01-02");
        multimap.put("name", "张三");
        multimap.put("name", "李四");
        for (String string : multimap.get("date")) {
            System.out.println(string);
        }



        Map<String,String> map = Maps.newHashMap();
        map.putIfAbsent("","");
        map.forEach( (key,value) ->
                System.out.println(key +" : "+value) //只能放一个啊
        );

        List<String> alist = Lists.newArrayList("a","b","c");
        List<String> blist = Lists.newArrayList("1","2","3");
        List<String> clist = Lists.newArrayList("甲","已","丙");

        for (String a : alist) {
            System.out.println(a);
            for ( String b : blist) {
                System.out.println(b);
                for ( String c : clist) {
                    System.out.println(c);
                }
            }
        }

        List<String> dlist = Lists.newArrayList("d");
        String ab = Iterables.getOnlyElement(dlist); //测试
        System.out.println(ab);

        String max = Collections.max(multimap.values());
        System.out.println(max);

        BiMap<Integer,String> logfileMap = HashBiMap.create();
        logfileMap.put(1,"a.log");
        logfileMap.put(2,"b.log");
        logfileMap.put(3,"c.log");
        logfileMap.put(4,"d.log");
        BiMap<String,Integer> filelogMap = logfileMap.inverse();
        System.out.println("logfileMap:"+filelogMap);

        logfileMap.forcePut(5,"d.log"); //插入重复的值

        //Map<String, Object> attrMap = objList.stream().collect(  //JDK1.8 将list转换为map对象
        //		Collectors.toMap(Object::getKey(), (p) -> p));


        //Map<Integer,Movie> mappedMovies = Maps.uniqueIndex(movies, new Function <Movie,Integer> () {
        //	public Integer apply(Movie from) {
        //		return from.getRank();
        //	}});

//		mark:
//		for (String a : alist) {
//			System.out.println(a);
//			for ( String b : blist) {
//				System.out.println(b);
//				for ( String c : clist) {
//					System.out.println(c);
//					continue mark;
//				}
//			}
//		}

        //
        //List<Map.Entry<String,Integer>> list =
        //		new ArrayList<Map.Entry<String,Integer>>(map.entrySet());
        //
        //Collections.sort(list, new Comparator<Map.Entry<String, Integer>>() { //map的value排序
        //	public int compare(Map.Entry<String, Integer> o1,
        //					   Map.Entry<String, Integer> o2) {
        //		return (o2.getValue() - o1.getValue());
        //	}
        //});


        System.out.println("执行到我了");


        //Stopwatch计时器
        Stopwatch stopwatch = Stopwatch.createStarted();
        String a = "";
        for (int i = 0; i < 30; i++) {
            a = a+i;
        }
        long nanos = stopwatch.elapsed(TimeUnit.SECONDS);
        System.out.println("共耗时："+nanos);

        List<String> elist = Lists.newArrayList("d");
        elist.forEach(str->{

        });


    }

    private void files() throws Exception{
        //文件处理：读取文件
        File testFile = new File("d:\\test.txt");
        List<String> lines = Files.readLines(testFile, Charsets.UTF_16);
        for (String line : lines) {
            System.out.println(line);
        }

        //文件处理：写入文件
        File newFile = new File("d:\\test.txt");
        Files.write("content".getBytes(), newFile);

        //文件处理：复制文件
        Files.copy(testFile, newFile); //sources target
    }

    //private static void genFile() throws Exception{
    //    String[] fieldNames = {"B1","B2"};
    //    String[] values = {"张三","lisi"};
    //
    //    InputStream license;
    //
    //    license = new PathMatchingResourcePatternResolver().getResource("/license.xml").getInputStream();
    //    License aposeLic = new License();
    //    aposeLic.setLicense(license);
    //
    //    FileInputStream word = new FileInputStream("C:\\Users\\Administrator\\Desktop\\test2.doc");
    //    Document doc = new Document(word);
    //    doc.getMailMerge().execute(fieldNames, values);
    //
    //    String filePath = "C:\\Users\\Administrator\\Desktop\\doc.docx";
    //    File file = new File(filePath);
    //    if(file.exists()) {
    //        file.delete();
    //    }
    //    file.createNewFile();
    //    FileOutputStream fileOS = new FileOutputStream(file);
    //    for (Bookmark mark: doc.getRange().getBookmarks()){
    //        if (mark != null)
    //        {
    //            if ( mark.getName().equals("T1") ) {
    //                DocumentBuilder builder = new DocumentBuilder(doc);
    //                String imgPath = "C:\\Users\\Administrator\\Desktop\\226480148719793700.jpg";
    //                String imgPath2 = "C:\\Users\\Administrator\\Desktop\\a.png";
    //                File file2 = new File(imgPath);
    //                if (file2.exists())
    //                {
    //                    builder.moveToBookmark("T1");
    //                    builder.insertImage(imgPath, RelativeHorizontalPosition.MARGIN, 1, RelativeVerticalPosition.MARGIN, 1, 100, 120, WrapType.SQUARE);
    //                    builder.insertImage(imgPath2);
    //                    //.InsertImage(imgPath, RelativeHorizontalPosition.Margin, 1, RelativeVerticalPosition.Margin, 1, 100, 125, WrapType.Square);
    //                }
    //            }
    //        }
    //    }
    //
    //    doc.save(fileOS, SaveFormat.DOC);
    //}


    public  void setCellText(XWPFTableCell cell,String text, String bgcolor) {
        CTTc cttc = cell.getCTTc();
        //CTTcPr cellPr = cttc.addNewTcPr();
        //cellPr.addNewTcW().setW(BigInteger.valueOf(width));
        //cell.setColor(bgcolor);
        CTTcPr ctPr = cttc.addNewTcPr();
        CTShd ctshd = ctPr.addNewShd();
        ctshd.setFill(bgcolor);
        ctPr.addNewVAlign().setVal(STVerticalJc.CENTER);
        cttc.getPList().get(0).addNewPPr().addNewJc().setVal(STJc.CENTER);
        cell.setText(text);
    }


    /**
     * @Description: 跨列合并
     */
    public  void mergeCellsHorizontal(XWPFTable table, int row, int fromCell, int toCell) {
        for (int cellIndex = fromCell; cellIndex <= toCell; cellIndex++) {
            XWPFTableCell cell = table.getRow(row).getCell(cellIndex);
            if ( cellIndex == fromCell ) {
                // The first merged cell is set with RESTART merge value
                cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.RESTART);
            } else {
                // Cells which join (merge) the first one, are set with CONTINUE
                cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.CONTINUE);
            }
        }
    }

    /**
     * @Description: 跨行合并
     */
    public  void mergeCellsVertically(XWPFTable table, int col, int fromRow, int toRow) {
        for (int rowIndex = fromRow; rowIndex <= toRow; rowIndex++) {
            XWPFTableCell cell = table.getRow(rowIndex).getCell(col);
            if ( rowIndex == fromRow ) {
                // The first merged cell is set with RESTART merge value
                cell.getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.RESTART);
            } else {
                // Cells which join (merge) the first one, are set with CONTINUE
                cell.getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.CONTINUE);
            }
        }
    }

    public void setTableWidth(XWPFTable table,String width){
        CTTbl ttbl = table.getCTTbl();
        CTTblPr tblPr = ttbl.getTblPr() == null ? ttbl.addNewTblPr() : ttbl.getTblPr();
        CTTblWidth tblWidth = tblPr.isSetTblW() ? tblPr.getTblW() : tblPr.addNewTblW();
        CTJc cTJc=tblPr.addNewJc();
        cTJc.setVal(STJc.Enum.forString("center"));
        tblWidth.setW(new BigInteger(width));
        tblWidth.setType(STTblWidth.DXA);
    }

    public void saveDocument(XWPFDocument document, String savePath)
            throws Exception {
        FileOutputStream fos = new FileOutputStream(savePath);
        document.write(fos);
        fos.close();
    }



}
