package com.risk.test;

import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

import java.io.*;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class FileAlterInfo {
    /**
     * 实现对word读取和修改操作
     *
     *            word模板路径和名称
     *            待填充的数据，从数据库读取
     * @throws IOException
     * @throws InvalidFormatException
     */
    public static void readwriteWord(String inFile, Map<String, Object> data) throws InvalidFormatException, IOException {
        InputStream is = new FileInputStream(inFile);
        XWPFDocument document;
        try {
            document = new XWPFDocument(OPCPackage.open(is));
            // 替换段落里面的变量
            replaceInPara(document, data);
            OutputStream os = new FileOutputStream(inFile);
            document.write(os);
            close(os);
            close(is);
        } catch (Exception e) {

            e.printStackTrace();
        }

    }

    /**
     * 替换段落里面的变量
     *
     * @param doc
     *            要替换的文档
     * @param params
     *            参数
     */
    private static void replaceInPara(XWPFDocument doc, Map<String, Object> params) {
        Iterator<XWPFParagraph> iterator = doc.getParagraphsIterator();
        XWPFParagraph para;
        while (iterator.hasNext()) {
            para = iterator.next();
            replaceInPara(para, params);
        }
    }

    /**
     * 替换段落里面的变量
     *
     * @param para
     *            要替换的段落
     * @param params
     *            参数
     */
    private static void replaceInPara(XWPFParagraph para, Map<String, Object> params) {
        List<XWPFRun> runs;
        Matcher matcher;
        String runText = "";

        if (matcher(para.getParagraphText()).find()) {
            runs = para.getRuns();
            if (runs.size() > 0) {
                int j = runs.size();
                for (int i = 0; i < j; i++) {
                    XWPFRun run = runs.get(0);
                    String i1 = run.toString();
                    runText += i1;
                    para.removeRun(0);

                }

            }
            System.out.println(runText);
            matcher = matcher(runText);

            if (matcher.find()) {
                while ((matcher = matcher(runText)).find()) {
                    runText = matcher.replaceFirst(String.valueOf(params.get(matcher.group(1))));
                }
                // 直接调用XWPFRun的setText()方法设置文本时，在底层会重新创建一个XWPFRun，把文本附加在当前文本后面，
                // 所以我们不能直接设值，需要先删除当前run,然后再自己手动插入一个新的run。
                try {
                    //para.insertNewRun(0).addPicture(new FileInputStream(new File("C:\\Users\\PVer\\Pictures\\Camera Roll\\evans.jpg")),
                    //        Document.PICTURE_TYPE_JPEG,"a.jpg",100,200);
                    //        //.getDocument().addPictureData(new FileInputStream(new File("C:\\Users\\PVer\\Pictures\\Camera Roll\\evans.jpg")), Document.PICTURE_TYPE_JPEG);
                }catch (Exception e){
                    e.printStackTrace();
                }
                para.insertNewRun(0).setText(runText);
            }
        }

    }

    /**
     * 正则匹配字符串
     *
     * @param str
     * @return
     */
    private static Matcher matcher(String str) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}", Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(str);
        return matcher;
    }

    /**
     * 关闭输入流
     *
     * @param is
     */
    private static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 关闭输出流
     *
     * @param os
     */
    private static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}