package com.risk.test;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class BaiduWeatherApi {

	public static String getWeatherInform(String cityName) {

	
		String baiduUrl = "http://api.map.baidu.com/telematics/v3/weather?location=厦门&output=json&ak=W69oaDTCfuGwzNwmtVvgWfGH";
		StringBuffer strBuf;

		try {

			baiduUrl = "http://api.map.baidu.com/telematics/v3/weather?location="
					+ URLEncoder.encode(cityName, "utf-8")
					+ "&output=json&ak=57ab4d7f7882e2028de5a9a589ae697f";
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		}

		strBuf = new StringBuffer();

		try {
			URL url = new URL(baiduUrl);
			URLConnection conn = url.openConnection();
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					conn.getInputStream(), "utf-8"));// ת�롣
			String line = null;
			while ((line = reader.readLine()) != null)
				strBuf.append(line + " ");
			reader.close();
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return strBuf.toString();
	}
	
	
	public static void main(String[] args) {
	
		String strPar=BaiduWeatherApi.getWeatherInform("厦门");
		 JSONObject dataOfJson = JSONObject.fromObject(strPar);
		 System.out.println(dataOfJson);
		 if(dataOfJson.getInt("error")!=0){
			 System.out.println("没有获取到数据");
		 }else{
			
			 System.out.println("日期："+dataOfJson.getString("date"));
			// ;
			 System.out.println(dataOfJson.getString("results"));
			 JSONArray array  =JSONArray.fromObject(dataOfJson.getString("results"));
			 JSONObject data = JSONObject.fromObject(array.get(0).toString());
			 System.out.println("城市："+data.getString("currentCity"));
			 JSONArray arrayweather  =JSONArray.fromObject(data.getString("weather_data"));
			 
			 JSONObject weather = JSONObject.fromObject(arrayweather.get(0).toString());
//			 "weather":"晴",
//             "wind":"东北风3-4级",
//             "temperature":"15 ~ 9℃"
			 System.out.println("天气："+weather.getString("weather"));
			 System.out.println("风向："+ weather.getString("wind"));
			 System.out.println("温度："+ weather.getString("temperature"));
			 System.out.println("pm："+data.getString("pm25"));
			 int pmnum=Integer.parseInt(data.getString("pm25"));
			 if(pmnum<50){
				 System.out.println("优");
			 }else if(pmnum<100){
				 System.out.println("良");
			 }else  if(pmnum<150){
				 System.out.println("轻度污染");
			 }else if(pmnum<200){
				 System.out.println("中度污染");
			 }else if(pmnum<300){
				 System.out.println("重度污染");
			 }else{
				 System.out.println("严重污染"); 
			 }
		 }
		
	}

}
