/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.generator.config.rules;

import com.bcxin.risk.hibernateplus.utils.StringUtils;

public enum NamingStrategy {
    nochange,
    underline_to_camel,
    remove_prefix,
    remove_prefix_and_camel;


    public static String underlineToCamel(String name) {
        String[] camels;
        if (StringUtils.isBlank(name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String camel : camels = name.toLowerCase().split("_")) {
            if (StringUtils.isBlank(camel)) continue;
            if (result.length() == 0) {
                result.append(camel);
                continue;
            }
            result.append(NamingStrategy.capitalFirst(camel));
        }
        return result.toString();
    }

    public static String removePrefix(String name) {
        if (StringUtils.isBlank(name)) {
            return "";
        }
        int idx = name.indexOf("_");
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static String removePrefix(String name, String prefix) {
        if (StringUtils.isBlank(name)) {
            return "";
        }
        int idx = name.indexOf("_");
        if (prefix != null && !"".equals(prefix.trim()) && name.toLowerCase().matches("^" + prefix.toLowerCase() + ".*")) {
            idx = prefix.length() - 1;
        }
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static String removePrefixAndCamel(String name, String tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String capitalFirst(String name) {
        if (StringUtils.isNotBlank(name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

