package com.bcxin.hb.hbzw;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 申报信息表
 * @author wangjianjun
 * @date 2020/8/17
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PreApasinfo extends Model<PreApasinfo> {
    /**
     * 办件编号全省统一，作为办件的唯一标识，生成规则详见《7.12办件编号生成规范》
     */
    private String PROJID;

    /**
     * 版本号,默认值=1，如果有信息变更，则版本号递增
     */
    private Integer DATAVERSION;

    /**
     * 查询密码。由业务系统随机自动生成的数字：234765
     */
    private String PROJPWD;

    /**
     * 审批事项编号
     */
    private String SERVICECODE;

    /**
     * 审批事项的版本号
     */
    private Integer SERVICEVERSION;

    /**
     * 审批事项名称
     */
    private String SERVICENAME;

    private String PROJECTNAME;

    /**
     * 办件类型: 即办件、承诺件
     */
    private String INFOTYPE;

    /**
     * 业务类型 0-普通办件 1-业务协同（并联）2-多级联动
     */
    private String BUS_TYPE;

    /**
     * 关联业务标识 当业务为并联业务时候，该项必填，值为牵头事项办件的ID；当业务为多级联动是，值为下级办件唯一标识
     */
    private String REL_BUS_ID;

    /**
     * 申报者名称：如为个人，则填写姓名；如为法人，则填写单位名称
     */
    private String APPLYNAME;

    /**
     * 申报者证件类型: 身份证、组织机构代码证等
     */
    private String APPLY_CARDTYPE;

    /**
     * 申报者证件号码
     */
    private String APPLY_CARDNUMBER;

    /**
     * 联系人/代理人姓名
     */
    private String CONTACTMAN;

    /**
     * 联系人/代理人证件类型
     */
    private String CONTACTMAN_CARDTYPE;

    /**
     * 联系人/代理人证件号码
     */
    private String CONTACTMAN_CARDNUMBER;

    /**
     * 联系人联系电话
     */
    private String TELPHONE;

    /**
     * 邮编
     */
    private String POSTCODE;

    /**
     * 通讯地址
     */
    private String ADDRESS;

    /**
     * 法人代表
     */
    private String LEGALMAN;

    /**
     * 收件部门标识
     */
    private String DEPTID;

    /**
     * 收件部门名称
     */
    private String DEPTNAME;

    /**
     * 申报来源: 政务服务网、物理大厅
     */
    private String APPLYFROM;

    /**
     * 申请人类型 标识办件是：个人申请或法人申请
     */
    private String APPLY_TYPE;

    /**
     * 办理方式 00=普通模式 01=快递送达 99=其他
     */
    private String BUS_MODE;

    /**
     * 办理方式说明 如果办理方式指为其他，可对该办理方式进行描述
     */
    private String BUS_MODE_DESC;

    /**
     * 是否是在垂管系统中运行的事项 0=非垂管事项 1=使用中央垂管系统的事项 2=使用省级垂管系统的事项
     * 3=使用市级垂管系统的事项
     * 4=使用县级垂管系统的事项
     */
    private String IS_MANUBRIUM;

    /**
     * 项目性质 指详见7.6项目性质
     */
    private String APPLY_PROPERTIY;

    /**
     * 申报时间 时间格式：yyyy-mm-ddhh24:mi:ss
     */
    private Date RECEIVETIME;

    /**
     * 受理时间 时间格式：yyyy-mm-ddhh24:mi:ss
     */
    private Date ACCEPT_TIME;

    /**
     * 承诺办结时间 时间格式：yyyy-mm-dd
     */
    private Date PROMISEE_TIME;

    /**
     * 办结时间 时间格式：yyyy-mm-ddhh24:mi:ss
     */
    private Date TRANSACT_TIME;

    /**
     * 办件状态
     */
    private String HANDLESTATE;

    /**
     * 项目关联号(有注册项目的需要填写项目关联号)
     */
    private String BELONGTO;

    /**
     * 所属地区编码
     */
    private String AREACODE;

    /**
     * 数据状态: 0=作废1=有效
     */
    private String DATASTATE;

    /**
     * 所属系统
     */
    private String BELONGSYSTEM;

    /**
     * 备用字段 投资平台办件为T,更新完之后为S
     */
    private String EXTEND;

    private String SYNC_STATUS;

    /**
     * 创建用户唯一标识（使用统一申报、统一受理由统一用户管理系统提供，其他使用本系统标识）
     */
    private String RECEIVE_USEID;

    /**
     * 创建用户名称
     */
    private String RECEIVE_NAME;

    /**
     * 数据产生时间
     */
    private Date CREATE_TIME;

    /**
     * 实施机构组织机构代码
     */
    private String SS_ORGCODE;

    /**
     * 权利事项类型
     */
    private String QL_KIND;

    /**
     * 流程XML详见7.15流程XML规范
     */
    private String FLOW_XML;

    /**
     * 业务数据交换时间戳
     */
    private Date JH_SJC_DXP;

    /**
     * 业务数据状态
     */
    private String JH_SJZT;

    /**
     * 业务数据上传机构标识
     */
    private String JH_SCJG;

    /**
     * 业务数据上传机构名称
     */
    private String JH_SCJGMC;

    /**
     * 业务数据目标机构标识
     */
    private String JH_MBJG;

    /**
     * 1推送到一窗大厅，0推送到厅局
     */
    private String JH_YCBJ;

    //表外
    /**
     * PreCommonForm表的xml字段
     */
    private transient String itemValues;

    @Override
    public Serializable pkVal() {
        return null;
    }

    public String getItemValues() {
        return this.itemValues;
    }

    public void setItemValues(String itemValues) {
        this.itemValues = itemValues;
    }
}