/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.LongUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.UserDao;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.dto.data.MenuDataDto;
import com.bcxin.risk.user.dto.data.PoliceUserDataDto;
import com.bcxin.risk.user.dto.data.UserDataDto;
import com.bcxin.risk.user.dto.data.UserDto;
import com.bcxin.risk.user.dto.data.UserRoleDataDto;
import com.bcxin.risk.user.dto.search.PoliceUserSearchDto;
import com.bcxin.risk.user.dto.search.UserRoleSearchDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class UserDaoImpl
extends DaoImpl<User>
implements UserDao {
    public User findUserByName(String name) {
        return (User)this.selectOne(CriterionWrapper.instance().eq("userName", (Object)name));
    }

    public User findUserByZwid(String zwid) {
        return (User)this.selectOne(CriterionWrapper.instance().eq("zwId", (Object)zwid));
    }

    public User findUserByEmail(String email) {
        return (User)this.selectOne(CriterionWrapper.instance().eq("email", (Object)email));
    }

    public User findUserByOid(long oid) {
        return (User)this.selectById(oid);
    }

    public List userList(DwzPage page, UserDto userDto) {
        String sql = "SELECT oid, DATE_FORMAT(createOn,'%Y-%m-%d %H:%i:%s') AS createOn,active,phone,userName,realName,email,userType,org_id FROM risk_se_user WHERE 1=1 and userType in ('1','3','4')";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (userDto != null) {
            if (StringUtil.isNotEmpty((String)userDto.getUserName())) {
                sql = sql + " AND userName like '%" + userDto.getUserName() + "%' ";
            }
            if (StringUtil.isNotEmpty((String)userDto.getRealName())) {
                sql = sql + " AND realName = '" + userDto.getRealName() + "' ";
            }
            if (StringUtil.isNotEmpty((String)userDto.getPhone())) {
                sql = sql + " AND phone = '" + userDto.getPhone() + "' ";
            }
            if (StringUtil.isNotEmpty((String)userDto.getActive())) {
                sql = sql + " AND active = '" + userDto.getActive() + "' ";
            }
            if (StringUtil.isNotEmpty((String)userDto.getUserType())) {
                sql = sql + " AND userType = '" + userDto.getUserType() + "' ";
            }
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " ORDER BY createOn DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public User findAdminUser() {
        ArrayList criterion = Lists.newArrayList();
        criterion.add(Restrictions.eq((String)"userType", (Object)"4"));
        List list = this.selectList(criterion);
        if (list.size() > 0) {
            return (User)list.get(0);
        }
        return null;
    }

    public List<UserRoleDataDto> queryUserList(UserRoleSearchDto dto) {
        Long oid = dto.getRole_id();
        String sql = "SELECT a.oid AS user_id,a.userName,a.realName,a.userType,(CASE WHEN b.orgType = '5' THEN CONCAT(c.serviceOrgType,'0')ELSE b.orgType END) AS orgType,(CASE WHEN (SELECT COUNT(1) FROM risk_user_role WHERE user_id = a.oid AND role_id = " + oid + ")>0 THEN 1 ELSE 0 END) AS xzbz FROM risk_se_user a, risk_org b LEFT JOIN risk_serviceOrg c ON c.oid = b.oid  WHERE a.org_id = b.oid AND a.active = '1' AND EXISTS (SELECT 1 FROM base_role WHERE oid = " + oid + " AND active = '1'  AND orgType = b.orgType AND IFNULL(serviceOrgType,99) = IFNULL(c.serviceOrgType,99)) ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (dto.getUserName() != null) {
            sql = sql + "AND a.userName like '%" + dto.getUserName() + "%' ";
        }
        wrapper.orderBy("a.oid", true);
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map map = result;
            UserRoleDataDto userRoleDataDto = new UserRoleDataDto(map);
            dtoList.add(userRoleDataDto);
        });
        return dtoList;
    }

    public List<UserRoleDataDto> queryUserOrRoleList(UserRoleSearchDto dto) {
        String sql = "SELECT a.oid AS user_id,a.userName,a.realName,a.userType,a.email,a.phone,a.orgAdmin,c.oid AS role_id,c.roleCode,c.roleName,c.roleDesc FROM risk_se_user a, risk_user_role b , base_role c WHERE a.oid = b.user_id AND b.role_id = c.oid AND a.active = '1' AND c.active = '1' ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty((String)dto.getRealName())) {
            sql = sql + " AND a.realName like '%" + dto.getRealName() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)dto.getUserName())) {
            sql = sql + " AND a.userName = '" + dto.getUserName() + "'";
        }
        if (StringUtil.isNotEmpty((String)dto.getRoleCode())) {
            sql = sql + " AND c.roleCode = '" + dto.getRoleCode() + "'";
        }
        if (StringUtil.isNotEmpty((String)dto.getRoleName())) {
            sql = sql + " AND c.roleName like '%" + dto.getRoleName() + "%' ";
        }
        if (dto.getUser_id() != null) {
            sql = sql + " AND a.oid = " + dto.getUser_id();
        }
        if (StringUtil.isNotEmpty((String)dto.getOrg_Id())) {
            sql = sql + " AND a.org_id  = " + dto.getOrg_Id();
        }
        if (dto.getRole_id() != null) {
            sql = sql + " AND c.oid = " + dto.getRole_id();
        }
        sql = sql + " ORDER BY a.oid ,c.oid  ";
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map map = result;
            UserRoleDataDto userRoleDataDto = new UserRoleDataDto(map);
            dtoList.add(userRoleDataDto);
        });
        return dtoList;
    }

    public List<MenuDataDto> queryMenuByUser(Long userId) {
        String sql = "SELECT DISTINCT e.oid, e.menuName,e.menuType FROM risk_se_user a ,risk_user_role b, base_role c ,base_role_menu d, base_menu e WHERE a.oid = b.user_id AND b.role_id = c.oid AND c.oid = d.role_id AND d.menu_id = e.oid AND a.oid = " + userId + " ORDER BY e.oid ";
        List list = this.queryMaps(sql);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            MenuDataDto dto = new MenuDataDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public UserDataDto findUserByOrgId(Long orgId) {
        String sql = "SELECT * FROM risk_se_user a WHERE a.org_id = " + orgId;
        List list = this.queryMaps(sql);
        UserDataDto dto = new UserDataDto((Map)list.get(0));
        return dto;
    }

    public List<UserRoleDataDto> queryUserListByOrgId(User user, String name, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = " SELECT b.oid AS user_id,b.userName ,b.realName ,b.active ,b.password ,b.email ,b.phone ,d.oid as role_id, d.roleName, b.signature From risk_serviceorg a,risk_se_user b,risk_user_role c,base_role d  WHERE a.oid = b.org_Id AND b.oid = c.user_id AND c.role_id=d.oid AND a.oid =" + user.getOrg().getOid() + "  AND b.oid != " + user.getOid() + " ";
        if (StringUtil.isNotEmpty((String)name)) {
            sql = sql + " AND b.userName like '%" + name + "%' ";
        }
        wrapper.orderBy("b.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            UserRoleDataDto dto = new UserRoleDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public User findPoliceUserByArea(Long area_id) {
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)(area_id + ""))) {
            // empty if block
        }
        criterionList.add(Restrictions.eq((String)"userType", (Object)"3"));
        List userList = this.selectPage(criterionList, null);
        if (CollectionUtil.isNotEmpty((Collection)userList)) {
            return (User)userList.get(0);
        }
        return new User();
    }

    public User findPoliceUserByRegion(Long regionId, String regionLevel) {
        ArrayList criterionList = Lists.newArrayList();
        switch (regionLevel) {
            case "3": {
                criterionList.add(Restrictions.eq((String)"area_id", (Object)regionId));
                break;
            }
            case "2": {
                criterionList.add(Restrictions.eq((String)"city_id", (Object)regionId));
                break;
            }
            case "1": {
                criterionList.add(Restrictions.eq((String)"province_id", (Object)regionId));
            }
        }
        criterionList.add(Restrictions.eq((String)"userType", (Object)"3"));
        List userList = this.selectPage(criterionList, null);
        if (CollectionUtil.isNotEmpty((Collection)userList)) {
            return (User)userList.get(0);
        }
        return new User();
    }

    public int updateUser(User user) {
        String sql;
        if (LongUtil.isNotEmpty((Long)user.getCity_id())) {
            sql = "Update risk_se_user  SET city_id = '" + user.getCity_id() + "'  WHERE oid = " + user.getOid();
            this.executeSqlUpdate(sql);
        }
        if (LongUtil.isNotEmpty((Long)user.getArea_id())) {
            sql = "Update risk_se_user  SET area_id = '" + user.getArea_id() + "'  WHERE oid = " + user.getOid();
            this.executeSqlUpdate(sql);
        }
        sql = "Update risk_se_user  SET phone = '" + user.getPhone() + "' , realName = '" + user.getRealName() + "' , email = '" + user.getEmail() + "' , province_id = '" + user.getProvince_id() + "' , updateOn = SYSDATE()  WHERE oid = " + user.getOid();
        return this.executeSqlUpdate(sql);
    }

    public int updateUserServiceOrg(String adminTel, String active) {
        String sql = "Update risk_se_user  SET active = '" + active + "' ,updateOn = SYSDATE()  WHERE username = '" + adminTel + "'";
        return this.executeSqlUpdate(sql);
    }

    public List findFrontUserList(UserDto userDto, DwzPage page) {
        String sql = "SELECT  a.oid,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,a.active,a.phone,a.userName,a.realName,a.email,a.userType,b.name AS orgName,b.govOrgFlag,(SELECT province FROM base_region WHERE oid = a.province_id) AS province,(SELECT city FROM base_region WHERE oid = a.city_id) AS city,(SELECT area FROM base_region WHERE oid = a.area_id) AS area  FROM risk_se_user a , risk_org b WHERE a.org_id = b.oid   AND a.userType IN ('1','20') ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (userDto != null) {
            if (StringUtil.isNotEmpty((String)userDto.getUserName())) {
                sql = sql + " AND a.userName = '" + userDto.getUserName() + "'";
            }
            if (StringUtil.isNotEmpty((String)userDto.getRealName())) {
                sql = sql + " AND a.realName = '" + userDto.getRealName() + "'";
            }
            if (StringUtil.isNotEmpty((String)userDto.getActive())) {
                sql = sql + " AND a.active = '" + userDto.getActive() + "'";
            }
            if (StringUtil.isNotEmpty((String)userDto.getUserType())) {
                sql = sql + " AND a.userType = '" + userDto.getUserType() + "'";
            }
            if (StringUtil.isNotEmpty((String)userDto.getGovOrgFlag())) {
                sql = sql + " AND IFNULL(b.govOrgFlag,'0') = '" + userDto.getGovOrgFlag() + "' ";
            }
            if (userDto.getArea_id() != null) {
                sql = sql + " AND a.area_id = " + userDto.getArea_id();
            }
            if (userDto.getCity_id() != null) {
                sql = sql + " AND a.city_id = " + userDto.getCity_id();
            }
            if (userDto.getProvince_id() != null) {
                sql = sql + " AND a.province_id = " + userDto.getProvince_id();
            }
        }
        sql = sql + " ORDER BY a.oid DESC";
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List<UserRoleDataDto> findCashierByuserType(String usertypeGljgyhCw) {
        String sql = "SELECT a.oid AS user_id,a.userName,a.realName,a.userType,a.email,a.phone,a.orgAdmin,c.oid AS role_id,c.roleCode,c.roleName,c.roleDesc FROM risk_se_user a, risk_user_role b , base_role c WHERE a.oid = b.user_id AND b.role_id = c.oid AND a.active = '1' AND c.active = '1' ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty((String)usertypeGljgyhCw)) {
            sql = sql + " AND a.userType = '" + usertypeGljgyhCw + "' ";
        }
        sql = sql + " ORDER BY a.oid DESC";
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            UserRoleDataDto dto = new UserRoleDataDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<User> findUserListByDto(UserDto dto) {
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)dto.getActive())) {
            criterionList.add(Restrictions.eq((String)"active", (Object)dto.getActive()));
        }
        criterionList.add(Restrictions.or((Criterion)Restrictions.eq((String)"isSync", (Object)"0"), (Criterion)Restrictions.isNull((String)"isSync")));
        if (StringUtil.isNotEmpty((String)dto.getOid())) {
            criterionList.add(Restrictions.eq((String)"oid", (Object)dto.getOid()));
        }
        Order order = Order.desc((String)"oid");
        return this.selectList(criterionList, order);
    }

    public List<PoliceUserDataDto> findPoliceUser(PoliceUserSearchDto dto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select oid , DATE_FORMAT(createOn, '%Y-%m-%d %H:%i:%s') AS createOn, province_id , city_id ,        area_id , realName , userName ,  phone , email , active      from risk_se_user where 1=1 and  userType = '3'  ";
        if (StringUtil.isNotEmpty((String)dto.getProvince())) {
            sql = sql + " and province_id = '" + dto.getProvince() + "' ";
        }
        if (StringUtil.isNotEmpty((String)dto.getCity())) {
            sql = sql + " and city_id = '" + dto.getCity() + "' ";
        }
        if (StringUtil.isNotEmpty((String)dto.getArea())) {
            sql = sql + " and area_id  = '" + dto.getArea() + "' ";
        }
        if (StringUtil.isNotEmpty((String)dto.getNotnull())) {
            sql = sql + " and " + dto.getNotnull() + " is NOT NULL ";
        }
        if (StringUtil.isNotEmpty((String)dto.getName())) {
            sql = sql + "AND realName like '%" + dto.getName() + "%' ";
        }
        wrapper.orderBy("createOn", false);
        wrapper.orderBy("oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            PoliceUserDataDto policeUserDataDto = new PoliceUserDataDto(result);
            policeUserDataDto.setPage(page);
            dtoList.add(policeUserDataDto);
        });
        return dtoList;
    }

    public List<UserRoleDataDto> queryUserList(Long orgId, String name, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = " SELECT b.oid AS user_id,b.userName ,b.realName ,b.active ,b.password ,b.email ,b.phone ,b.userType ,b.signature FROM risk_serviceorg a,risk_se_user b WHERE a.oid = b.org_Id AND a.oid =" + orgId + " ";
        if (StringUtil.isNotEmpty((String)name)) {
            sql = sql + " AND b.userName like '%" + name + "%' ";
        }
        wrapper.orderBy("b.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            UserRoleDataDto dto = new UserRoleDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public UserDataDto findUserByOrgName(String orgName) {
        String sql = "SELECT\n\tt1.* \nFROM\n\trisk_se_user t1\n\tLEFT JOIN risk_org t2 ON t1.org_id = t2.oid\n\tWHERE t2.`name` ='" + orgName + "'";
        List list = this.queryMaps(sql);
        if (list.size() == 0) {
            return null;
        }
        UserDataDto dto = new UserDataDto((Map)list.get(0));
        return dto;
    }

    public void deleteUserDaoByOid(User user) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (user != null) {
            wrapper.eq("oid", (Object)user.getOid());
        }
        this.delete((Wrapper)wrapper);
    }
}

